/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpebble.stormcrawler.tika;

import com.digitalpebble.stormcrawler.Metadata;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;

public class RedirectionBolt
extends BaseRichBolt {
    private OutputCollector collector;

    public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
    }

    public void execute(Tuple tuple) {
        String url = tuple.getStringByField("url");
        byte[] content = tuple.getBinaryByField("content");
        Metadata metadata = (Metadata)tuple.getValueByField("metadata");
        String text = tuple.getStringByField("text");
        Values v = new Values(new Object[]{url, content, metadata, text});
        if (metadata.getFirstValue("parsed.by") != null) {
            this.collector.emit(tuple, (List)v);
        } else {
            this.collector.emit("tika", tuple, (List)v);
        }
        this.collector.ack(tuple);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(new String[]{"url", "content", "metadata", "text"}));
        declarer.declareStream("tika", new Fields(new String[]{"url", "content", "metadata", "text"}));
    }
}

