/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.fsm.dsl;

import com.digitalpetri.fsm.dsl.ActionBuilder;
import com.digitalpetri.fsm.dsl.TransitionAction;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Predicate;

public class ViaBuilder<S, E> {
    private final Predicate<S> fromFilter;
    private final Predicate<S> toFilter;
    private final LinkedList<TransitionAction<S, E>> transitionActions;

    ViaBuilder(Predicate<S> fromFilter, Predicate<S> toFilter, LinkedList<TransitionAction<S, E>> transitionActions) {
        this.fromFilter = fromFilter;
        this.toFilter = toFilter;
        this.transitionActions = transitionActions;
    }

    public ActionBuilder<S, E> via(E event) {
        return new ActionBuilder<S, Object>(this.fromFilter, this.toFilter, e -> Objects.equals(e, event), this.transitionActions);
    }

    public ActionBuilder<S, E> via(Class<? extends E> eventClass) {
        return new ActionBuilder<S, Object>(this.fromFilter, this.toFilter, e -> Objects.equals(e.getClass(), eventClass), this.transitionActions);
    }

    public ActionBuilder<S, E> via(Predicate<E> eventFilter) {
        return new ActionBuilder<S, E>(this.fromFilter, this.toFilter, eventFilter, this.transitionActions);
    }

    public ActionBuilder<S, E> viaAny() {
        return new ActionBuilder<S, Object>(this.fromFilter, this.toFilter, e -> true, this.transitionActions);
    }
}

