/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.codec;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.LoggerFactory;

public final class Modbus {
    private static NioEventLoopGroup EVENT_LOOP;
    private static ExecutorService EXECUTOR_SERVICE;
    private static ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE;
    private static HashedWheelTimer WHEEL_TIMER;

    private Modbus() {
    }

    public static synchronized NioEventLoopGroup sharedEventLoop() {
        if (EVENT_LOOP == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final AtomicLong threadNumber = new AtomicLong(0L);

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "modbus-netty-event-loop-" + this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            EVENT_LOOP = new NioEventLoopGroup(0, threadFactory);
        }
        return EVENT_LOOP;
    }

    public static synchronized ExecutorService sharedExecutor() {
        if (EXECUTOR_SERVICE == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final AtomicLong threadNumber = new AtomicLong(0L);

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "modbus-shared-thread-pool-" + this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler((t, e) -> LoggerFactory.getLogger(Modbus.class).warn("Uncaught Exception on shared stack ExecutorService thread!", e));
                    return thread;
                }
            };
            EXECUTOR_SERVICE = Executors.newCachedThreadPool(threadFactory);
        }
        return EXECUTOR_SERVICE;
    }

    public static synchronized ScheduledExecutorService sharedScheduledExecutor() {
        if (SCHEDULED_EXECUTOR_SERVICE == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final AtomicLong threadNumber = new AtomicLong(0L);

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "modbus-shared-scheduled-executor-" + this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler((t, e) -> LoggerFactory.getLogger(Modbus.class).warn("Uncaught Exception on shared stack ScheduledExecutorService thread!", e));
                    return thread;
                }
            };
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), threadFactory);
            executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            SCHEDULED_EXECUTOR_SERVICE = executor;
        }
        return SCHEDULED_EXECUTOR_SERVICE;
    }

    public static synchronized HashedWheelTimer sharedWheelTimer() {
        if (WHEEL_TIMER == null) {
            ThreadFactory threadFactory = r -> {
                Thread thread = new Thread(r, "modbus-netty-wheel-timer");
                thread.setDaemon(true);
                return thread;
            };
            WHEEL_TIMER = new HashedWheelTimer(threadFactory);
        }
        return WHEEL_TIMER;
    }

    public static synchronized void releaseSharedResources() {
        Modbus.releaseSharedResources(5L, TimeUnit.SECONDS);
    }

    public static synchronized void releaseSharedResources(long timeout, TimeUnit unit) {
        if (EVENT_LOOP != null) {
            try {
                EVENT_LOOP.shutdownGracefully().await(timeout, unit);
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(Modbus.class).warn("Interrupted awaiting event loop shutdown.", (Throwable)e);
            }
            EVENT_LOOP = null;
        }
        if (SCHEDULED_EXECUTOR_SERVICE != null) {
            SCHEDULED_EXECUTOR_SERVICE.shutdown();
        }
        if (EXECUTOR_SERVICE != null) {
            EXECUTOR_SERVICE.shutdown();
        }
        if (SCHEDULED_EXECUTOR_SERVICE != null) {
            try {
                SCHEDULED_EXECUTOR_SERVICE.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(Modbus.class).warn("Interrupted awaiting scheduled executor service shutdown.", (Throwable)e);
            }
            SCHEDULED_EXECUTOR_SERVICE = null;
        }
        if (EXECUTOR_SERVICE != null) {
            try {
                EXECUTOR_SERVICE.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(Modbus.class).warn("Interrupted awaiting executor service shutdown.", (Throwable)e);
            }
            EXECUTOR_SERVICE = null;
        }
        if (WHEEL_TIMER != null) {
            WHEEL_TIMER.stop().forEach(Timeout::cancel);
            WHEEL_TIMER = null;
        }
    }
}

