/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.codec;

import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.codec.ModbusPduEncoder;
import com.digitalpetri.modbus.responses.ExceptionResponse;
import com.digitalpetri.modbus.responses.MaskWriteRegisterResponse;
import com.digitalpetri.modbus.responses.ReadCoilsResponse;
import com.digitalpetri.modbus.responses.ReadDiscreteInputsResponse;
import com.digitalpetri.modbus.responses.ReadHoldingRegistersResponse;
import com.digitalpetri.modbus.responses.ReadInputRegistersResponse;
import com.digitalpetri.modbus.responses.ReadWriteMultipleRegistersResponse;
import com.digitalpetri.modbus.responses.WriteMultipleCoilsResponse;
import com.digitalpetri.modbus.responses.WriteMultipleRegistersResponse;
import com.digitalpetri.modbus.responses.WriteSingleCoilResponse;
import com.digitalpetri.modbus.responses.WriteSingleRegisterResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;

public class ModbusResponseEncoder
implements ModbusPduEncoder {
    @Override
    public ByteBuf encode(ModbusPdu modbusPdu, ByteBuf buffer) throws EncoderException {
        try {
            if (modbusPdu instanceof ExceptionResponse) {
                ByteBuf byteBuf = this.encodeExceptionResponse((ExceptionResponse)modbusPdu, buffer);
                return byteBuf;
            }
            switch (modbusPdu.getFunctionCode()) {
                case ReadCoils: {
                    ByteBuf byteBuf = this.encodeReadCoils((ReadCoilsResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case ReadDiscreteInputs: {
                    ByteBuf byteBuf = this.encodeReadDiscreteInputs((ReadDiscreteInputsResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case ReadHoldingRegisters: {
                    ByteBuf byteBuf = this.encodeReadHoldingRegisters((ReadHoldingRegistersResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case ReadInputRegisters: {
                    ByteBuf byteBuf = this.encodeReadInputRegisters((ReadInputRegistersResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case WriteSingleCoil: {
                    ByteBuf byteBuf = this.encodeWriteSingleCoil((WriteSingleCoilResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case WriteSingleRegister: {
                    ByteBuf byteBuf = this.encodeWriteSingleRegister((WriteSingleRegisterResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case WriteMultipleCoils: {
                    ByteBuf byteBuf = this.encodeWriteMultipleCoils((WriteMultipleCoilsResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case WriteMultipleRegisters: {
                    ByteBuf byteBuf = this.encodeWriteMultipleRegisters((WriteMultipleRegistersResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case MaskWriteRegister: {
                    ByteBuf byteBuf = this.encodeMaskWriteRegister((MaskWriteRegisterResponse)modbusPdu, buffer);
                    return byteBuf;
                }
                case ReadWriteMultipleRegisters: {
                    ByteBuf byteBuf = this.encodeReadWriteMultipleRegisters((ReadWriteMultipleRegistersResponse)modbusPdu, buffer);
                    return byteBuf;
                }
            }
            throw new EncoderException("FunctionCode not supported: " + modbusPdu.getFunctionCode());
        }
        finally {
            ReferenceCountUtil.release((Object)modbusPdu);
        }
    }

    private ByteBuf encodeExceptionResponse(ExceptionResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode() + 128);
        buffer.writeByte(response.getExceptionCode().getCode());
        return buffer;
    }

    private ByteBuf encodeReadCoils(ReadCoilsResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeByte(response.getCoilStatus().readableBytes());
        buffer.writeBytes(response.getCoilStatus());
        return buffer;
    }

    private ByteBuf encodeReadDiscreteInputs(ReadDiscreteInputsResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeByte(response.getInputStatus().readableBytes());
        buffer.writeBytes(response.getInputStatus());
        return buffer;
    }

    private ByteBuf encodeReadHoldingRegisters(ReadHoldingRegistersResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeByte(response.getRegisters().readableBytes());
        buffer.writeBytes(response.getRegisters());
        return buffer;
    }

    private ByteBuf encodeReadInputRegisters(ReadInputRegistersResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeByte(response.getRegisters().readableBytes());
        buffer.writeBytes(response.getRegisters());
        return buffer;
    }

    private ByteBuf encodeWriteSingleCoil(WriteSingleCoilResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeShort(response.getAddress());
        buffer.writeShort(response.getValue());
        return buffer;
    }

    private ByteBuf encodeWriteSingleRegister(WriteSingleRegisterResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeShort(response.getAddress());
        buffer.writeShort(response.getValue());
        return buffer;
    }

    private ByteBuf encodeWriteMultipleCoils(WriteMultipleCoilsResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeShort(response.getAddress());
        buffer.writeShort(response.getQuantity());
        return buffer;
    }

    private ByteBuf encodeWriteMultipleRegisters(WriteMultipleRegistersResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeShort(response.getAddress());
        buffer.writeShort(response.getQuantity());
        return buffer;
    }

    private ByteBuf encodeMaskWriteRegister(MaskWriteRegisterResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeShort(response.getAddress());
        buffer.writeShort(response.getAndMask());
        buffer.writeShort(response.getOrMask());
        return buffer;
    }

    private ByteBuf encodeReadWriteMultipleRegisters(ReadWriteMultipleRegistersResponse response, ByteBuf buffer) {
        buffer.writeByte(response.getFunctionCode().getCode());
        buffer.writeByte(response.getRegisters().readableBytes());
        buffer.writeBytes(response.getRegisters());
        return buffer;
    }
}

