/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.slave;

import com.codahale.metrics.Counter;
import com.digitalpetri.modbus.ExceptionCode;
import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.codec.ModbusPduDecoder;
import com.digitalpetri.modbus.codec.ModbusPduEncoder;
import com.digitalpetri.modbus.codec.ModbusRequestDecoder;
import com.digitalpetri.modbus.codec.ModbusResponseEncoder;
import com.digitalpetri.modbus.codec.ModbusTcpCodec;
import com.digitalpetri.modbus.codec.ModbusTcpPayload;
import com.digitalpetri.modbus.requests.ModbusRequest;
import com.digitalpetri.modbus.responses.ExceptionResponse;
import com.digitalpetri.modbus.responses.ModbusResponse;
import com.digitalpetri.modbus.slave.ModbusTcpSlaveConfig;
import com.digitalpetri.modbus.slave.ServiceRequestHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcpSlave {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<ServiceRequestHandler> requestHandler = new AtomicReference<1>(new ServiceRequestHandler(){});
    private final Map<SocketAddress, Channel> serverChannels = new ConcurrentHashMap<SocketAddress, Channel>();
    private final Counter channelCounter = new Counter();
    private final ModbusTcpSlaveConfig config;

    public ModbusTcpSlave(ModbusTcpSlaveConfig config) {
        this.config = config;
    }

    public CompletableFuture<ModbusTcpSlave> bind(String host, int port) {
        CompletableFuture<ModbusTcpSlave> bindFuture = new CompletableFuture<ModbusTcpSlave>();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                ModbusTcpSlave.this.channelCounter.inc();
                ModbusTcpSlave.this.logger.info("channel initialized: {}", (Object)channel);
                channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
                channel.pipeline().addLast(new ChannelHandler[]{new ModbusTcpCodec((ModbusPduEncoder)new ModbusResponseEncoder(), (ModbusPduDecoder)new ModbusRequestDecoder())});
                channel.pipeline().addLast(new ChannelHandler[]{new ModbusTcpSlaveHandler(ModbusTcpSlave.this)});
                channel.closeFuture().addListener(future -> ModbusTcpSlave.this.channelCounter.dec());
            }
        };
        this.config.getBootstrapConsumer().accept(bootstrap);
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.config.getEventLoop()).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)initializer).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.bind(host, port).addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                this.serverChannels.put(channel.localAddress(), channel);
                bindFuture.complete(this);
            } else {
                bindFuture.completeExceptionally(future.cause());
            }
        });
        return bindFuture;
    }

    public void setRequestHandler(ServiceRequestHandler requestHandler) {
        this.requestHandler.set(requestHandler);
    }

    public void shutdown() {
        this.serverChannels.values().forEach(ChannelOutboundInvoker::close);
        this.serverChannels.clear();
    }

    private void onChannelRead(ChannelHandlerContext ctx, ModbusTcpPayload payload) {
        ServiceRequestHandler handler = this.requestHandler.get();
        if (handler == null) {
            return;
        }
        switch (payload.getModbusPdu().getFunctionCode()) {
            case ReadCoils: {
                handler.onReadCoils(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case ReadDiscreteInputs: {
                handler.onReadDiscreteInputs(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case ReadHoldingRegisters: {
                handler.onReadHoldingRegisters(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case ReadInputRegisters: {
                handler.onReadInputRegisters(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case WriteSingleCoil: {
                handler.onWriteSingleCoil(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case WriteSingleRegister: {
                handler.onWriteSingleRegister(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case WriteMultipleCoils: {
                handler.onWriteMultipleCoils(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case WriteMultipleRegisters: {
                handler.onWriteMultipleRegisters(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case MaskWriteRegister: {
                handler.onMaskWriteRegister(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            case ReadWriteMultipleRegisters: {
                handler.onReadWriteMultipleRegisters(ModbusTcpServiceRequest.of(payload, ctx.channel()));
                break;
            }
            default: {
                ExceptionResponse response = new ExceptionResponse(payload.getModbusPdu().getFunctionCode(), ExceptionCode.IllegalFunction);
                ctx.writeAndFlush((Object)new ModbusTcpPayload(payload.getTransactionId(), payload.getUnitId(), (ModbusPdu)response));
            }
        }
    }

    private void onChannelInactive(ChannelHandlerContext ctx) {
        this.logger.debug("Master/client channel closed: {}", (Object)ctx.channel());
    }

    private void onExceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("Exception caught on channel: {}", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }

    private static class ModbusTcpServiceRequest<Request extends ModbusRequest, Response extends ModbusResponse>
    implements ServiceRequestHandler.ServiceRequest<Request, Response> {
        private final short transactionId;
        private final short unitId;
        private final Request request;
        private final Channel channel;

        private ModbusTcpServiceRequest(short transactionId, short unitId, Request request, Channel channel) {
            this.transactionId = transactionId;
            this.unitId = unitId;
            this.request = request;
            this.channel = channel;
        }

        @Override
        public short getTransactionId() {
            return this.transactionId;
        }

        @Override
        public short getUnitId() {
            return this.unitId;
        }

        @Override
        public Request getRequest() {
            return this.request;
        }

        @Override
        public Channel getChannel() {
            return this.channel;
        }

        @Override
        public void sendResponse(Response response) {
            this.channel.writeAndFlush((Object)new ModbusTcpPayload(this.transactionId, this.unitId, response));
        }

        @Override
        public void sendException(ExceptionCode exceptionCode) {
            ExceptionResponse response = new ExceptionResponse(this.request.getFunctionCode(), exceptionCode);
            this.channel.writeAndFlush((Object)new ModbusTcpPayload(this.transactionId, this.unitId, (ModbusPdu)response));
        }

        public static <Request extends ModbusRequest, Response extends ModbusResponse> ModbusTcpServiceRequest<Request, Response> of(ModbusTcpPayload payload, Channel channel) {
            return new ModbusTcpServiceRequest<ModbusRequest, Response>(payload.getTransactionId(), payload.getUnitId(), (ModbusRequest)payload.getModbusPdu(), channel);
        }
    }

    private static class ModbusTcpSlaveHandler
    extends SimpleChannelInboundHandler<ModbusTcpPayload> {
        private final ModbusTcpSlave slave;

        private ModbusTcpSlaveHandler(ModbusTcpSlave slave) {
            this.slave = slave;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ModbusTcpPayload msg) {
            this.slave.onChannelRead(ctx, msg);
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.slave.onChannelInactive(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.slave.onExceptionCaught(ctx, cause);
        }
    }
}

