/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.slave;

import com.digitalpetri.modbus.codec.Modbus;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class ModbusTcpSlaveConfig {
    private final Optional<String> instanceId;
    private final ExecutorService executor;
    private final EventLoopGroup eventLoop;
    private final HashedWheelTimer wheelTimer;
    private final Consumer<ServerBootstrap> bootstrapConsumer;

    public ModbusTcpSlaveConfig(Optional<String> instanceId, ExecutorService executor, EventLoopGroup eventLoop, HashedWheelTimer wheelTimer, Consumer<ServerBootstrap> bootstrapConsumer) {
        this.instanceId = instanceId;
        this.executor = executor;
        this.eventLoop = eventLoop;
        this.wheelTimer = wheelTimer;
        this.bootstrapConsumer = bootstrapConsumer;
    }

    public Optional<String> getInstanceId() {
        return this.instanceId;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public EventLoopGroup getEventLoop() {
        return this.eventLoop;
    }

    public HashedWheelTimer getWheelTimer() {
        return this.wheelTimer;
    }

    public Consumer<ServerBootstrap> getBootstrapConsumer() {
        return this.bootstrapConsumer;
    }

    public static class Builder {
        private Optional<String> instanceId = Optional.empty();
        private ExecutorService executor;
        private EventLoopGroup eventLoop;
        private HashedWheelTimer wheelTimer;
        private Consumer<ServerBootstrap> bootstrapConsumer = b -> {};

        public Builder setInstanceId(String instanceId) {
            this.instanceId = Optional.of(instanceId);
            return this;
        }

        public Builder setExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder setEventLoop(EventLoopGroup eventLoop) {
            this.eventLoop = eventLoop;
            return this;
        }

        public Builder setWheelTimer(HashedWheelTimer wheelTimer) {
            this.wheelTimer = wheelTimer;
            return this;
        }

        public Builder setBootstrapConsumer(Consumer<ServerBootstrap> consumer) {
            this.bootstrapConsumer = consumer;
            return this;
        }

        public ModbusTcpSlaveConfig build() {
            return new ModbusTcpSlaveConfig(this.instanceId, this.executor != null ? this.executor : Modbus.sharedExecutor(), (EventLoopGroup)(this.eventLoop != null ? this.eventLoop : Modbus.sharedEventLoop()), this.wheelTimer != null ? this.wheelTimer : Modbus.sharedWheelTimer(), this.bootstrapConsumer);
        }
    }
}

