/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.slave;

import com.digitalpetri.modbus.ExceptionCode;
import com.digitalpetri.modbus.requests.MaskWriteRegisterRequest;
import com.digitalpetri.modbus.requests.ModbusRequest;
import com.digitalpetri.modbus.requests.ReadCoilsRequest;
import com.digitalpetri.modbus.requests.ReadDiscreteInputsRequest;
import com.digitalpetri.modbus.requests.ReadHoldingRegistersRequest;
import com.digitalpetri.modbus.requests.ReadInputRegistersRequest;
import com.digitalpetri.modbus.requests.ReadWriteMultipleRegistersRequest;
import com.digitalpetri.modbus.requests.WriteMultipleCoilsRequest;
import com.digitalpetri.modbus.requests.WriteMultipleRegistersRequest;
import com.digitalpetri.modbus.requests.WriteSingleCoilRequest;
import com.digitalpetri.modbus.requests.WriteSingleRegisterRequest;
import com.digitalpetri.modbus.responses.MaskWriteRegisterResponse;
import com.digitalpetri.modbus.responses.ModbusResponse;
import com.digitalpetri.modbus.responses.ReadCoilsResponse;
import com.digitalpetri.modbus.responses.ReadDiscreteInputsResponse;
import com.digitalpetri.modbus.responses.ReadHoldingRegistersResponse;
import com.digitalpetri.modbus.responses.ReadInputRegistersResponse;
import com.digitalpetri.modbus.responses.ReadWriteMultipleRegistersResponse;
import com.digitalpetri.modbus.responses.WriteMultipleCoilsResponse;
import com.digitalpetri.modbus.responses.WriteMultipleRegistersResponse;
import com.digitalpetri.modbus.responses.WriteSingleCoilResponse;
import com.digitalpetri.modbus.responses.WriteSingleRegisterResponse;
import io.netty.channel.Channel;
import io.netty.util.ReferenceCountUtil;

public interface ServiceRequestHandler {
    default public void onReadHoldingRegisters(ServiceRequest<ReadHoldingRegistersRequest, ReadHoldingRegistersResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onReadInputRegisters(ServiceRequest<ReadInputRegistersRequest, ReadInputRegistersResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onReadCoils(ServiceRequest<ReadCoilsRequest, ReadCoilsResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onReadDiscreteInputs(ServiceRequest<ReadDiscreteInputsRequest, ReadDiscreteInputsResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onWriteSingleCoil(ServiceRequest<WriteSingleCoilRequest, WriteSingleCoilResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onWriteSingleRegister(ServiceRequest<WriteSingleRegisterRequest, WriteSingleRegisterResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onWriteMultipleCoils(ServiceRequest<WriteMultipleCoilsRequest, WriteMultipleCoilsResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onWriteMultipleRegisters(ServiceRequest<WriteMultipleRegistersRequest, WriteMultipleRegistersResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onMaskWriteRegister(ServiceRequest<MaskWriteRegisterRequest, MaskWriteRegisterResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    default public void onReadWriteMultipleRegisters(ServiceRequest<ReadWriteMultipleRegistersRequest, ReadWriteMultipleRegistersResponse> service) {
        service.sendException(ExceptionCode.IllegalFunction);
        ReferenceCountUtil.release((Object)service.getRequest());
    }

    public static interface ServiceRequest<Request extends ModbusRequest, Response extends ModbusResponse> {
        public short getTransactionId();

        public short getUnitId();

        public Request getRequest();

        public Channel getChannel();

        public void sendResponse(Response var1);

        public void sendException(ExceptionCode var1);
    }
}

