/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.LoggerFactory;

public final class Netty {
    private static NioEventLoopGroup EVENT_LOOP;
    private static HashedWheelTimer WHEEL_TIMER;

    public static synchronized NioEventLoopGroup sharedEventLoop() {
        if (EVENT_LOOP == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final AtomicLong threadNumber = new AtomicLong(0L);

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, "modbus-netty-event-loop-" + this.threadNumber.getAndIncrement());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            EVENT_LOOP = new NioEventLoopGroup(1, threadFactory);
        }
        return EVENT_LOOP;
    }

    public static synchronized HashedWheelTimer sharedWheelTimer() {
        if (WHEEL_TIMER == null) {
            ThreadFactory threadFactory = r -> {
                Thread thread = new Thread(r, "modbus-netty-wheel-timer");
                thread.setDaemon(true);
                return thread;
            };
            WHEEL_TIMER = new HashedWheelTimer(threadFactory);
        }
        return WHEEL_TIMER;
    }

    public static synchronized void releaseSharedResources() {
        Netty.releaseSharedResources(5L, TimeUnit.SECONDS);
    }

    public static synchronized void releaseSharedResources(long timeout, TimeUnit unit) {
        if (EVENT_LOOP != null) {
            try {
                if (!EVENT_LOOP.shutdownGracefully().await(timeout, unit)) {
                    LoggerFactory.getLogger(Netty.class).warn("Event loop not shut down after {} {}.", (Object)timeout, (Object)unit);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LoggerFactory.getLogger(Netty.class).warn("Interrupted awaiting event loop shutdown", (Throwable)e);
            }
            EVENT_LOOP = null;
        }
        if (WHEEL_TIMER != null) {
            WHEEL_TIMER.stop().forEach(Timeout::cancel);
            WHEEL_TIMER = null;
        }
    }
}

