/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp.client;

import com.digitalpetri.modbus.Modbus;
import com.digitalpetri.modbus.tcp.Netty;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public record NettyClientTransportConfig(String hostname, int port, Duration connectTimeout, boolean connectPersistent, boolean reconnectLazy, EventLoopGroup eventLoopGroup, ExecutorService executor, Consumer<Bootstrap> bootstrapCustomizer, Consumer<ChannelPipeline> pipelineCustomizer, boolean tlsEnabled, Optional<KeyManagerFactory> keyManagerFactory, Optional<TrustManagerFactory> trustManagerFactory) {
    public static NettyClientTransportConfig create(Consumer<Builder> configure) {
        Builder builder = new Builder();
        configure.accept(builder);
        return builder.build();
    }

    public static class Builder {
        public String hostname;
        public int port = -1;
        public Duration connectTimeout = Duration.ofSeconds(5L);
        public boolean connectPersistent = true;
        public boolean reconnectLazy = false;
        public EventLoopGroup eventLoopGroup;
        public ExecutorService executor;
        public Consumer<Bootstrap> bootstrapCustomizer = b -> {};
        public Consumer<ChannelPipeline> pipelineCustomizer = p -> {};
        public boolean tlsEnabled = false;
        public KeyManagerFactory keyManagerFactory = null;
        public TrustManagerFactory trustManagerFactory = null;

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setConnectPersistent(boolean connectPersistent) {
            this.connectPersistent = connectPersistent;
            return this;
        }

        public Builder setReconnectLazy(boolean reconnectLazy) {
            this.reconnectLazy = reconnectLazy;
            return this;
        }

        public Builder setEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public Builder setExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder setBootstrapCustomizer(Consumer<Bootstrap> bootstrapCustomizer) {
            this.bootstrapCustomizer = bootstrapCustomizer;
            return this;
        }

        public Builder setPipelineCustomizer(Consumer<ChannelPipeline> pipelineCustomizer) {
            this.pipelineCustomizer = pipelineCustomizer;
            return this;
        }

        public Builder setTlsEnabled(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public Builder setKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
            this.keyManagerFactory = keyManagerFactory;
            return this;
        }

        public Builder setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
            this.trustManagerFactory = trustManagerFactory;
            return this;
        }

        public NettyClientTransportConfig build() {
            if (this.hostname == null) {
                throw new NullPointerException("hostname must not be null");
            }
            if (this.port == -1) {
                int n = this.port = this.tlsEnabled ? 802 : 502;
            }
            if (this.eventLoopGroup == null) {
                this.eventLoopGroup = Netty.sharedEventLoop();
            }
            if (this.executor == null) {
                this.executor = Modbus.sharedExecutor();
            }
            if (this.tlsEnabled) {
                if (this.keyManagerFactory == null) {
                    throw new NullPointerException("keyManagerFactory must not be null");
                }
                if (this.trustManagerFactory == null) {
                    throw new NullPointerException("trustManagerFactory must not be null");
                }
            }
            return new NettyClientTransportConfig(this.hostname, this.port, this.connectTimeout, this.connectPersistent, this.reconnectLazy, this.eventLoopGroup, this.executor, this.bootstrapCustomizer, this.pipelineCustomizer, this.tlsEnabled, Optional.ofNullable(this.keyManagerFactory), Optional.ofNullable(this.trustManagerFactory));
        }
    }
}

