/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp.client;

import com.digitalpetri.fsm.FsmContext;
import com.digitalpetri.modbus.ModbusRtuFrame;
import com.digitalpetri.modbus.ModbusRtuResponseFrameParser;
import com.digitalpetri.modbus.client.ModbusRtuClientTransport;
import com.digitalpetri.modbus.internal.util.ExecutionQueue;
import com.digitalpetri.modbus.tcp.client.NettyClientTransportConfig;
import com.digitalpetri.modbus.tcp.client.NettyTcpClientTransport;
import com.digitalpetri.netty.fsm.ChannelActions;
import com.digitalpetri.netty.fsm.ChannelFsm;
import com.digitalpetri.netty.fsm.ChannelFsmConfig;
import com.digitalpetri.netty.fsm.ChannelFsmFactory;
import com.digitalpetri.netty.fsm.Event;
import com.digitalpetri.netty.fsm.State;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRtuClientTransport
implements ModbusRtuClientTransport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ModbusRtuResponseFrameParser frameParser = new ModbusRtuResponseFrameParser();
    private final AtomicReference<Consumer<ModbusRtuFrame>> frameReceiver = new AtomicReference();
    private final List<NettyTcpClientTransport.ConnectionListener> connectionListeners = new CopyOnWriteArrayList<NettyTcpClientTransport.ConnectionListener>();
    private final ChannelFsm channelFsm;
    private final ExecutionQueue executionQueue;
    private final NettyClientTransportConfig config;

    public NettyRtuClientTransport(NettyClientTransportConfig config) {
        this.config = config;
        this.channelFsm = ChannelFsmFactory.newChannelFsm((ChannelFsmConfig)ChannelFsmConfig.newBuilder().setExecutor((Executor)config.executor()).setLazy(config.reconnectLazy()).setPersistent(config.connectPersistent()).setChannelActions((ChannelActions)new ModbusRtuChannelActions()).build());
        this.channelFsm.addTransitionListener((from, to, via) -> {
            this.logger.debug("onStateTransition: {} -> {} via {}", new Object[]{from, to, via});
            this.maybeNotifyConnectionListeners(from, to);
        });
        this.executionQueue = new ExecutionQueue((Executor)config.executor());
    }

    private void maybeNotifyConnectionListeners(State from, State to) {
        if (this.connectionListeners.isEmpty()) {
            return;
        }
        if (from != State.Connected && to == State.Connected) {
            this.executionQueue.submit(() -> this.connectionListeners.forEach(NettyTcpClientTransport.ConnectionListener::onConnection));
        } else if (from == State.Connected && to != State.Connected) {
            this.executionQueue.submit(() -> this.connectionListeners.forEach(NettyTcpClientTransport.ConnectionListener::onConnectionLost));
        }
    }

    public CompletableFuture<Void> connect() {
        return this.channelFsm.connect().thenApply(c -> null);
    }

    public CompletableFuture<Void> disconnect() {
        return this.channelFsm.disconnect();
    }

    public boolean isConnected() {
        return this.channelFsm.getState() == State.Connected;
    }

    public ChannelFsm getChannelFsm() {
        return this.channelFsm;
    }

    public void addConnectionListener(NettyTcpClientTransport.ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(NettyTcpClientTransport.ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public CompletionStage<Void> send(ModbusRtuFrame frame) {
        return this.channelFsm.getChannel().thenCompose(channel -> {
            ByteBuf buffer = Unpooled.buffer();
            buffer.writeByte(frame.unitId());
            buffer.writeBytes(frame.pdu());
            buffer.writeBytes(frame.crc());
            CompletableFuture future = new CompletableFuture();
            channel.writeAndFlush((Object)buffer).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(channelFuture.cause());
                }
            }));
            return future;
        });
    }

    public void receive(Consumer<ModbusRtuFrame> frameReceiver) {
        this.frameReceiver.set(frameReceiver);
    }

    public void resetFrameParser() {
        this.frameParser.reset();
    }

    public static NettyRtuClientTransport create(Consumer<NettyClientTransportConfig.Builder> configure) {
        NettyClientTransportConfig config = NettyClientTransportConfig.create(configure);
        return new NettyRtuClientTransport(config);
    }

    private class ModbusRtuChannelActions
    implements ChannelActions {
        private ModbusRtuChannelActions() {
        }

        public CompletableFuture<Channel> connect(FsmContext<State, Event> fsmContext) {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(NettyRtuClientTransport.this.config.eventLoopGroup())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)NettyRtuClientTransport.this.config.connectTimeout().toMillis()))).option(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    if (NettyRtuClientTransport.this.config.tlsEnabled()) {
                        SslContext sslContext = SslContextBuilder.forClient().clientAuth(ClientAuth.REQUIRE).keyManager(NettyRtuClientTransport.this.config.keyManagerFactory().orElseThrow()).trustManager(NettyRtuClientTransport.this.config.trustManagerFactory().orElseThrow()).protocols(new String[]{"TLSv1.2", "TLSv1.3"}).build();
                        channel.pipeline().addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc(), NettyRtuClientTransport.this.config.hostname(), NettyRtuClientTransport.this.config.port())});
                    }
                    channel.pipeline().addLast(new ChannelHandler[]{new ModbusRtuClientFrameReceiver()});
                    NettyRtuClientTransport.this.config.pipelineCustomizer().accept(channel.pipeline());
                }
            });
            NettyRtuClientTransport.this.config.bootstrapCustomizer().accept(bootstrap);
            CompletableFuture<Channel> future = new CompletableFuture<Channel>();
            bootstrap.connect(NettyRtuClientTransport.this.config.hostname(), NettyRtuClientTransport.this.config.port()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    future.complete(channelFuture.channel());
                } else {
                    future.completeExceptionally(channelFuture.cause());
                }
            }));
            return future;
        }

        public CompletableFuture<Void> disconnect(FsmContext<State, Event> fsmContext, Channel channel) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            channel.close().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> future.complete(null)));
            return future;
        }
    }

    private class ModbusRtuClientFrameReceiver
    extends SimpleChannelInboundHandler<ByteBuf> {
        private ModbusRtuClientFrameReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) {
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            ModbusRtuResponseFrameParser.ParserState state = NettyRtuClientTransport.this.frameParser.parse(data);
            if (state instanceof ModbusRtuResponseFrameParser.Accumulated) {
                ModbusRtuResponseFrameParser.Accumulated a = (ModbusRtuResponseFrameParser.Accumulated)state;
                try {
                    this.onFrameReceived(a.frame());
                }
                finally {
                    NettyRtuClientTransport.this.frameParser.reset();
                }
            } else if (state instanceof ModbusRtuResponseFrameParser.ParseError) {
                ModbusRtuResponseFrameParser.ParseError e = (ModbusRtuResponseFrameParser.ParseError)state;
                NettyRtuClientTransport.this.logger.error("Error parsing frame: {}", (Object)e.error());
                NettyRtuClientTransport.this.frameParser.reset();
                ctx.close();
            }
        }

        private void onFrameReceived(ModbusRtuFrame frame) {
            Consumer<ModbusRtuFrame> frameReceiver = NettyRtuClientTransport.this.frameReceiver.get();
            if (frameReceiver != null) {
                NettyRtuClientTransport.this.executionQueue.submit(() -> frameReceiver.accept(frame));
            }
        }
    }
}

