/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp.client;

import com.digitalpetri.fsm.FsmContext;
import com.digitalpetri.modbus.ModbusTcpFrame;
import com.digitalpetri.modbus.client.ModbusTcpClientTransport;
import com.digitalpetri.modbus.internal.util.ExecutionQueue;
import com.digitalpetri.modbus.tcp.ModbusTcpCodec;
import com.digitalpetri.modbus.tcp.client.NettyClientTransportConfig;
import com.digitalpetri.netty.fsm.ChannelActions;
import com.digitalpetri.netty.fsm.ChannelFsm;
import com.digitalpetri.netty.fsm.ChannelFsmConfig;
import com.digitalpetri.netty.fsm.ChannelFsmFactory;
import com.digitalpetri.netty.fsm.Event;
import com.digitalpetri.netty.fsm.State;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpClientTransport
implements ModbusTcpClientTransport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<Consumer<ModbusTcpFrame>> frameReceiver = new AtomicReference();
    private final List<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    private final ChannelFsm channelFsm;
    private final ExecutionQueue executionQueue;
    private final NettyClientTransportConfig config;

    public NettyTcpClientTransport(NettyClientTransportConfig config) {
        this.config = config;
        this.channelFsm = ChannelFsmFactory.newChannelFsm((ChannelFsmConfig)ChannelFsmConfig.newBuilder().setExecutor((Executor)config.executor()).setLazy(config.reconnectLazy()).setPersistent(config.connectPersistent()).setChannelActions((ChannelActions)new ModbusTcpChannelActions()).setLoggerName("com.digitalpetri.modbus.client.ChannelFsm").build());
        this.executionQueue = new ExecutionQueue((Executor)config.executor());
        this.channelFsm.addTransitionListener((from, to, via) -> {
            this.logger.debug("onStateTransition: {} -> {} via {}", new Object[]{from, to, via});
            this.maybeNotifyConnectionListeners(from, to);
        });
    }

    private void maybeNotifyConnectionListeners(State from, State to) {
        if (this.connectionListeners.isEmpty()) {
            return;
        }
        if (from != State.Connected && to == State.Connected) {
            this.executionQueue.submit(() -> this.connectionListeners.forEach(ConnectionListener::onConnection));
        } else if (from == State.Connected && to != State.Connected) {
            this.executionQueue.submit(() -> this.connectionListeners.forEach(ConnectionListener::onConnectionLost));
        }
    }

    public CompletableFuture<Void> connect() {
        return this.channelFsm.connect().thenApply(c -> null);
    }

    public CompletableFuture<Void> disconnect() {
        return this.channelFsm.disconnect();
    }

    public CompletionStage<Void> send(ModbusTcpFrame frame) {
        return this.channelFsm.getChannel().thenCompose(channel -> {
            CompletableFuture future = new CompletableFuture();
            channel.writeAndFlush((Object)frame).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(channelFuture.cause());
                }
            }));
            return future;
        });
    }

    public void receive(Consumer<ModbusTcpFrame> frameReceiver) {
        this.frameReceiver.set(frameReceiver);
    }

    public boolean isConnected() {
        return this.channelFsm.getState() == State.Connected;
    }

    public ChannelFsm getChannelFsm() {
        return this.channelFsm;
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public static NettyTcpClientTransport create(Consumer<NettyClientTransportConfig.Builder> configure) {
        NettyClientTransportConfig config = NettyClientTransportConfig.create(configure);
        return new NettyTcpClientTransport(config);
    }

    private class ModbusTcpChannelActions
    implements ChannelActions {
        private ModbusTcpChannelActions() {
        }

        public CompletableFuture<Channel> connect(FsmContext<State, Event> fsmContext) {
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(NettyTcpClientTransport.this.config.eventLoopGroup())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)NettyTcpClientTransport.this.config.connectTimeout().toMillis()))).option(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE)).handler(this.newChannelInitializer());
            NettyTcpClientTransport.this.config.bootstrapCustomizer().accept(bootstrap);
            CompletableFuture<Channel> future = new CompletableFuture<Channel>();
            bootstrap.connect(NettyTcpClientTransport.this.config.hostname(), NettyTcpClientTransport.this.config.port()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
                if (channelFuture.isSuccess()) {
                    Channel channel = channelFuture.channel();
                    if (NettyTcpClientTransport.this.config.tlsEnabled()) {
                        ((SslHandler)channel.pipeline().get(SslHandler.class)).handshakeFuture().addListener(handshakeFuture -> {
                            if (handshakeFuture.isSuccess()) {
                                future.complete(channel);
                            } else {
                                future.completeExceptionally(handshakeFuture.cause());
                            }
                        });
                    } else {
                        future.complete(channel);
                    }
                } else {
                    future.completeExceptionally(channelFuture.cause());
                }
            }));
            return future;
        }

        private ChannelInitializer<SocketChannel> newChannelInitializer() {
            return new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    if (NettyTcpClientTransport.this.config.tlsEnabled()) {
                        SslContext sslContext = SslContextBuilder.forClient().clientAuth(ClientAuth.REQUIRE).keyManager(NettyTcpClientTransport.this.config.keyManagerFactory().orElseThrow()).trustManager(NettyTcpClientTransport.this.config.trustManagerFactory().orElseThrow()).protocols(new String[]{"TLSv1.2", "TLSv1.3"}).build();
                        channel.pipeline().addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc(), NettyTcpClientTransport.this.config.hostname(), NettyTcpClientTransport.this.config.port())});
                    }
                    channel.pipeline().addLast(new ChannelHandler[]{new ModbusTcpCodec()});
                    channel.pipeline().addLast(new ChannelHandler[]{new ModbusTcpFrameHandler()});
                    NettyTcpClientTransport.this.config.pipelineCustomizer().accept(channel.pipeline());
                }
            };
        }

        public CompletableFuture<Void> disconnect(FsmContext<State, Event> fsmContext, Channel channel) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            channel.close().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> future.complete(null)));
            return future;
        }
    }

    public static interface ConnectionListener {
        public void onConnection();

        public void onConnectionLost();
    }

    private class ModbusTcpFrameHandler
    extends SimpleChannelInboundHandler<ModbusTcpFrame> {
        private ModbusTcpFrameHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, ModbusTcpFrame frame) {
            Consumer<ModbusTcpFrame> frameReceiver = NettyTcpClientTransport.this.frameReceiver.get();
            if (frameReceiver != null) {
                NettyTcpClientTransport.this.executionQueue.submit(() -> frameReceiver.accept(frame));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            NettyTcpClientTransport.this.logger.error("Exception caught", cause);
            ctx.close();
        }
    }
}

