/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class SecurityUtil {
    public static KeyManagerFactory createKeyManagerFactory(PrivateKey privateKey, X509Certificate ... certificates) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", privateKey, new char[0], certificates);
        return SecurityUtil.createKeyManagerFactory(keyStore, new char[0]);
    }

    public static KeyManagerFactory createKeyManagerFactory(KeyStore keyStore, char[] keyStorePassword) throws GeneralSecurityException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, keyStorePassword);
        return keyManagerFactory;
    }

    public static TrustManagerFactory createTrustManagerFactory(X509Certificate ... certificates) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        for (int i = 0; i < certificates.length; ++i) {
            keyStore.setCertificateEntry("cert" + i, certificates[i]);
        }
        return SecurityUtil.createTrustManagerFactory(keyStore);
    }

    public static TrustManagerFactory createTrustManagerFactory(KeyStore keyStore) throws GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }
}

