/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp.server;

import com.digitalpetri.modbus.server.ModbusRequestContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;

class NettyRequestContext
implements ModbusRequestContext.ModbusTcpTlsRequestContext,
ModbusRequestContext.ModbusRtuTlsRequestContext {
    private static final AttributeKey<String> CLIENT_ROLE = AttributeKey.valueOf((String)"clientRole");
    private static final AttributeKey<X509Certificate[]> CLIENT_CERTIFICATE_CHAIN = AttributeKey.valueOf((String)"clientCertificateChain");
    private final ChannelHandlerContext ctx;

    NettyRequestContext(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public SocketAddress localAddress() {
        return this.ctx.channel().localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.ctx.channel().remoteAddress();
    }

    public Optional<String> clientRole() {
        Attribute attr = this.ctx.channel().attr(CLIENT_ROLE);
        String clientRole = (String)attr.get();
        if (clientRole == null) {
            X509Certificate x509Certificate = this.clientCertificateChain()[0];
            byte[] bs = x509Certificate.getExtensionValue("1.3.6.1.4.1.50316.802.1");
            clientRole = bs != null && bs.length >= 4 ? new String(bs, 4, bs.length - 4) : "";
            attr.set((Object)clientRole);
        }
        if (clientRole.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(clientRole);
    }

    public X509Certificate[] clientCertificateChain() {
        Attribute attr = this.ctx.channel().attr(CLIENT_CERTIFICATE_CHAIN);
        X509Certificate[] clientCertificateChain = (X509Certificate[])attr.get();
        if (clientCertificateChain == null) {
            try {
                SslHandler handler = (SslHandler)this.ctx.channel().pipeline().get(SslHandler.class);
                Certificate[] peerCertificates = handler.engine().getSession().getPeerCertificates();
                clientCertificateChain = (X509Certificate[])Arrays.stream(peerCertificates).map(cert -> (X509Certificate)cert).toArray(X509Certificate[]::new);
                attr.set((Object)clientCertificateChain);
            }
            catch (SSLPeerUnverifiedException e) {
                throw new RuntimeException(e);
            }
        }
        return clientCertificateChain;
    }
}

