/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp.server;

import com.digitalpetri.modbus.ModbusRtuFrame;
import com.digitalpetri.modbus.ModbusRtuRequestFrameParser;
import com.digitalpetri.modbus.exceptions.UnknownUnitIdException;
import com.digitalpetri.modbus.internal.util.ExecutionQueue;
import com.digitalpetri.modbus.server.ModbusRequestContext;
import com.digitalpetri.modbus.server.ModbusRtuServerTransport;
import com.digitalpetri.modbus.server.ModbusServerTransport;
import com.digitalpetri.modbus.tcp.server.NettyRequestContext;
import com.digitalpetri.modbus.tcp.server.NettyServerTransportConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRtuServerTransport
implements ModbusRtuServerTransport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<ModbusServerTransport.FrameReceiver<ModbusRequestContext.ModbusRtuRequestContext, ModbusRtuFrame>> frameReceiver = new AtomicReference();
    private final ModbusRtuRequestFrameParser frameParser = new ModbusRtuRequestFrameParser();
    private final AtomicReference<ServerSocketChannel> serverChannel = new AtomicReference();
    private final AtomicReference<Channel> clientChannel = new AtomicReference();
    private final ExecutionQueue executionQueue;
    private final NettyServerTransportConfig config;

    public NettyRtuServerTransport(NettyServerTransportConfig config) {
        this.config = config;
        this.executionQueue = new ExecutionQueue((Executor)config.executor(), 1);
    }

    public CompletionStage<Void> bind() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                if (NettyRtuServerTransport.this.clientChannel.compareAndSet(null, (Channel)channel)) {
                    if (NettyRtuServerTransport.this.config.tlsEnabled()) {
                        SslContext sslContext = SslContextBuilder.forServer((KeyManagerFactory)NettyRtuServerTransport.this.config.keyManagerFactory().orElseThrow()).clientAuth(ClientAuth.REQUIRE).trustManager(NettyRtuServerTransport.this.config.trustManagerFactory().orElseThrow()).protocols(new String[]{"TLSv1.2", "TLSv1.3"}).build();
                        channel.pipeline().addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc())});
                    }
                    channel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelInactive(ChannelHandlerContext ctx) {
                            NettyRtuServerTransport.this.clientChannel.set(null);
                        }
                    }}).addLast(new ChannelHandler[]{new ModbusRtuServerFrameReceiver()});
                    NettyRtuServerTransport.this.config.pipelineCustomizer().accept(channel.pipeline());
                } else {
                    channel.close();
                }
            }
        });
        bootstrap.group(this.config.eventLoopGroup());
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE);
        this.config.bootstrapCustomizer().accept(bootstrap);
        bootstrap.bind(this.config.bindAddress(), this.config.port()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.serverChannel.set((ServerSocketChannel)channelFuture.channel());
                future.complete(null);
            } else {
                future.completeExceptionally(channelFuture.cause());
            }
        }));
        return future;
    }

    public CompletionStage<Void> unbind() {
        ServerSocketChannel channel = this.serverChannel.getAndSet(null);
        if (channel != null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            channel.close().addListener((GenericFutureListener)((ChannelFutureListener)cf -> {
                Channel ch = this.clientChannel.getAndSet(null);
                if (ch != null) {
                    ch.close();
                }
                if (cf.isSuccess()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(cf.cause());
                }
            }));
            return future;
        }
        return CompletableFuture.completedFuture(null);
    }

    public void receive(ModbusServerTransport.FrameReceiver<ModbusRequestContext.ModbusRtuRequestContext, ModbusRtuFrame> frameReceiver) {
        this.frameReceiver.set(frameReceiver);
    }

    public static NettyRtuServerTransport create(Consumer<NettyServerTransportConfig.Builder> configure) {
        NettyServerTransportConfig.Builder builder = new NettyServerTransportConfig.Builder();
        configure.accept(builder);
        return new NettyRtuServerTransport(builder.build());
    }

    private class ModbusRtuServerFrameReceiver
    extends SimpleChannelInboundHandler<ByteBuf> {
        private ModbusRtuServerFrameReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf buffer) {
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            ModbusRtuRequestFrameParser.ParserState state = NettyRtuServerTransport.this.frameParser.parse(data);
            if (state instanceof ModbusRtuRequestFrameParser.Accumulated) {
                ModbusRtuRequestFrameParser.Accumulated a = (ModbusRtuRequestFrameParser.Accumulated)state;
                try {
                    this.onFrameReceived(ctx, a.frame());
                }
                finally {
                    NettyRtuServerTransport.this.frameParser.reset();
                }
            } else if (state instanceof ModbusRtuRequestFrameParser.ParseError) {
                ModbusRtuRequestFrameParser.ParseError e = (ModbusRtuRequestFrameParser.ParseError)state;
                NettyRtuServerTransport.this.logger.error("Error parsing frame: {}", (Object)e.message());
                NettyRtuServerTransport.this.frameParser.reset();
                ctx.close();
            }
        }

        private void onFrameReceived(ChannelHandlerContext ctx, ModbusRtuFrame requestFrame) {
            ModbusServerTransport.FrameReceiver<ModbusRequestContext.ModbusRtuRequestContext, ModbusRtuFrame> frameReceiver = NettyRtuServerTransport.this.frameReceiver.get();
            if (frameReceiver != null) {
                NettyRtuServerTransport.this.executionQueue.submit(() -> {
                    try {
                        ModbusRtuFrame responseFrame = (ModbusRtuFrame)frameReceiver.receive((Object)new NettyRequestContext(ctx), (Object)requestFrame);
                        ByteBuf buffer = Unpooled.buffer();
                        buffer.writeByte(responseFrame.unitId());
                        buffer.writeBytes(responseFrame.pdu());
                        buffer.writeBytes(responseFrame.crc());
                        ctx.channel().writeAndFlush((Object)buffer);
                    }
                    catch (UnknownUnitIdException e) {
                        NettyRtuServerTransport.this.logger.debug("Ignoring request for unknown unit id: {}", (Object)requestFrame.unitId());
                    }
                    catch (Exception e) {
                        NettyRtuServerTransport.this.logger.error("Error handling frame: {}", (Object)e.getMessage(), (Object)e);
                        ctx.close();
                    }
                });
            }
        }
    }
}

