/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp.server;

import com.digitalpetri.modbus.Modbus;
import com.digitalpetri.modbus.tcp.Netty;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public record NettyServerTransportConfig(String bindAddress, int port, EventLoopGroup eventLoopGroup, ExecutorService executor, Consumer<ServerBootstrap> bootstrapCustomizer, Consumer<ChannelPipeline> pipelineCustomizer, boolean tlsEnabled, Optional<KeyManagerFactory> keyManagerFactory, Optional<TrustManagerFactory> trustManagerFactory) {
    public static NettyServerTransportConfig create(Consumer<Builder> configure) {
        Builder builder = new Builder();
        configure.accept(builder);
        return builder.build();
    }

    public static class Builder {
        public String bindAddress = "0.0.0.0";
        public int port = -1;
        public EventLoopGroup eventLoopGroup;
        public ExecutorService executor;
        public Consumer<ServerBootstrap> bootstrapCustomizer = b -> {};
        public Consumer<ChannelPipeline> pipelineCustomizer = p -> {};
        public boolean tlsEnabled = false;
        public KeyManagerFactory keyManagerFactory = null;
        public TrustManagerFactory trustManagerFactory = null;

        public Builder setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public Builder setExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder setBootstrapCustomizer(Consumer<ServerBootstrap> bootstrapCustomizer) {
            this.bootstrapCustomizer = bootstrapCustomizer;
            return this;
        }

        public Builder setPipelineCustomizer(Consumer<ChannelPipeline> pipelineCustomizer) {
            this.pipelineCustomizer = pipelineCustomizer;
            return this;
        }

        public Builder setTlsEnabled(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public Builder setKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
            this.keyManagerFactory = keyManagerFactory;
            return this;
        }

        public Builder setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
            this.trustManagerFactory = trustManagerFactory;
            return this;
        }

        public NettyServerTransportConfig build() {
            if (this.port == -1) {
                int n = this.port = this.tlsEnabled ? 802 : 502;
            }
            if (this.eventLoopGroup == null) {
                this.eventLoopGroup = Netty.sharedEventLoop();
            }
            if (this.executor == null) {
                this.executor = Modbus.sharedExecutor();
            }
            return new NettyServerTransportConfig(this.bindAddress, this.port, this.eventLoopGroup, this.executor, this.bootstrapCustomizer, this.pipelineCustomizer, this.tlsEnabled, Optional.ofNullable(this.keyManagerFactory), Optional.ofNullable(this.trustManagerFactory));
        }
    }
}

