/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.tcp.server;

import com.digitalpetri.modbus.ModbusTcpFrame;
import com.digitalpetri.modbus.exceptions.UnknownUnitIdException;
import com.digitalpetri.modbus.internal.util.ExecutionQueue;
import com.digitalpetri.modbus.server.ModbusRequestContext;
import com.digitalpetri.modbus.server.ModbusServerTransport;
import com.digitalpetri.modbus.server.ModbusTcpServerTransport;
import com.digitalpetri.modbus.tcp.ModbusTcpCodec;
import com.digitalpetri.modbus.tcp.server.NettyRequestContext;
import com.digitalpetri.modbus.tcp.server.NettyServerTransportConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTcpServerTransport
implements ModbusTcpServerTransport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<ModbusServerTransport.FrameReceiver<ModbusRequestContext.ModbusTcpRequestContext, ModbusTcpFrame>> frameReceiver = new AtomicReference();
    private final AtomicReference<ServerSocketChannel> serverChannel = new AtomicReference();
    private final List<Channel> clientChannels = new CopyOnWriteArrayList<Channel>();
    private final ExecutionQueue executionQueue;
    private final NettyServerTransportConfig config;

    public NettyTcpServerTransport(NettyServerTransportConfig config) {
        this.config = config;
        this.executionQueue = new ExecutionQueue((Executor)config.executor(), 1);
    }

    public void receive(ModbusServerTransport.FrameReceiver<ModbusRequestContext.ModbusTcpRequestContext, ModbusTcpFrame> frameReceiver) {
        this.frameReceiver.set(frameReceiver);
    }

    public CompletableFuture<Void> bind() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                NettyTcpServerTransport.this.clientChannels.add((Channel)channel);
                if (NettyTcpServerTransport.this.config.tlsEnabled()) {
                    SslContext sslContext = SslContextBuilder.forServer((KeyManagerFactory)NettyTcpServerTransport.this.config.keyManagerFactory().orElseThrow()).clientAuth(ClientAuth.REQUIRE).trustManager(NettyTcpServerTransport.this.config.trustManagerFactory().orElseThrow()).protocols(new String[]{"TLSv1.2", "TLSv1.3"}).build();
                    channel.pipeline().addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc())});
                }
                channel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelInactive(ChannelHandlerContext ctx) {
                        NettyTcpServerTransport.this.clientChannels.remove(ctx.channel());
                    }
                }}).addLast(new ChannelHandler[]{new ModbusTcpCodec()}).addLast(new ChannelHandler[]{new ModbusTcpFrameHandler()});
                NettyTcpServerTransport.this.config.pipelineCustomizer().accept(channel.pipeline());
            }
        });
        bootstrap.group(this.config.eventLoopGroup());
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE);
        this.config.bootstrapCustomizer().accept(bootstrap);
        bootstrap.bind(this.config.bindAddress(), this.config.port()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            if (channelFuture.isSuccess()) {
                this.serverChannel.set((ServerSocketChannel)channelFuture.channel());
                future.complete(null);
            } else {
                future.completeExceptionally(channelFuture.cause());
            }
        }));
        return future;
    }

    public CompletableFuture<Void> unbind() {
        ServerSocketChannel channel = this.serverChannel.getAndSet(null);
        if (channel != null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            channel.close().addListener((GenericFutureListener)((ChannelFutureListener)cf -> {
                this.clientChannels.forEach(ChannelOutboundInvoker::close);
                this.clientChannels.clear();
                if (cf.isSuccess()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(cf.cause());
                }
            }));
            return future;
        }
        return CompletableFuture.completedFuture(null);
    }

    public static NettyTcpServerTransport create(Consumer<NettyServerTransportConfig.Builder> configure) {
        NettyServerTransportConfig.Builder builder = new NettyServerTransportConfig.Builder();
        configure.accept(builder);
        return new NettyTcpServerTransport(builder.build());
    }

    private class ModbusTcpFrameHandler
    extends SimpleChannelInboundHandler<ModbusTcpFrame> {
        private ModbusTcpFrameHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            NettyTcpServerTransport.this.logger.error("Exception caught", cause);
            ctx.close();
        }

        protected void channelRead0(ChannelHandlerContext ctx, ModbusTcpFrame requestFrame) {
            ModbusServerTransport.FrameReceiver<ModbusRequestContext.ModbusTcpRequestContext, ModbusTcpFrame> frameReceiver = NettyTcpServerTransport.this.frameReceiver.get();
            if (frameReceiver != null) {
                NettyTcpServerTransport.this.executionQueue.submit(() -> {
                    try {
                        ModbusTcpFrame responseFrame = (ModbusTcpFrame)frameReceiver.receive((Object)new NettyRequestContext(ctx), (Object)requestFrame);
                        ctx.channel().writeAndFlush((Object)responseFrame);
                    }
                    catch (UnknownUnitIdException e) {
                        NettyTcpServerTransport.this.logger.debug("Ignoring request for unknown unit id: {}", (Object)requestFrame.header().unitId());
                    }
                    catch (Exception e) {
                        NettyTcpServerTransport.this.logger.error("Error handling frame: {}", (Object)e.getMessage(), (Object)e);
                        ctx.close();
                    }
                });
            }
        }
    }
}

