/*
 * Decompiled with CFR 0.152.
 */
package com.dimafeng.testcontainers;

import com.dimafeng.testcontainers.ContainerDef;
import com.dimafeng.testcontainers.GenericContainer;
import com.dimafeng.testcontainers.SchemaRegistryContainer$;
import com.dimafeng.testcontainers.SchemaRegistryContainer$Def$;
import java.io.Serializable;
import org.testcontainers.containers.Network;
import scala.Predef$;
import scala.Product;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class SchemaRegistryContainer
extends GenericContainer {
    private final int schemaPort;

    public static SchemaRegistryContainer apply(Network network, String string, String string2, int n) {
        return SchemaRegistryContainer$.MODULE$.apply(network, string, string2, n);
    }

    public static int defaultSchemaPort() {
        return SchemaRegistryContainer$.MODULE$.defaultSchemaPort();
    }

    public static String apply$default$3() {
        return SchemaRegistryContainer$.MODULE$.apply$default$3();
    }

    public static int apply$default$4() {
        return SchemaRegistryContainer$.MODULE$.apply$default$4();
    }

    public SchemaRegistryContainer(Network network, String kafkaHost, String confluentPlatformVersion, int schemaPort) {
        this.schemaPort = schemaPort;
        super(new org.testcontainers.containers.GenericContainer(new StringBuilder(32).append("confluentinc/cp-schema-registry:").append(confluentPlatformVersion).toString()));
        this.container().withExposedPorts(new Integer[]{Predef$.MODULE$.int2Integer(schemaPort)});
        this.container().withNetwork(network);
        this.container().setEnv((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new StringBuilder(26).append("SCHEMA_REGISTRY_HOST_NAME=").append(this.container().getHost()).toString(), (List)new .colon.colon((Object)new StringBuilder(50).append("SCHEMA_REGISTRY_KAFKASTORE_BOOTSTRAP_SERVERS=").append(kafkaHost).append(":9092").toString(), (List)Nil$.MODULE$))).asJava());
    }

    public String schemaUrl() {
        return new StringBuilder(8).append("http://").append(this.container().getHost()).append(":").append(this.container().getMappedPort(this.schemaPort)).toString();
    }

    public static class Def
    implements ContainerDef,
    Product,
    Serializable {
        private final Network network;
        private final String kafkaHost;
        private final String confluentPlatformVersion;
        private final int schemaPort;

        public static Def apply(Network network, String string, String string2, int n) {
            return SchemaRegistryContainer$Def$.MODULE$.apply(network, string, string2, n);
        }

        public static Def fromProduct(Product product) {
            return SchemaRegistryContainer$Def$.MODULE$.fromProduct(product);
        }

        public static Def unapply(Def def) {
            return SchemaRegistryContainer$Def$.MODULE$.unapply(def);
        }

        public static String $lessinit$greater$default$3() {
            return SchemaRegistryContainer$Def$.MODULE$.$lessinit$greater$default$3();
        }

        public static int $lessinit$greater$default$4() {
            return SchemaRegistryContainer$Def$.MODULE$.$lessinit$greater$default$4();
        }

        public Def(Network network, String kafkaHost, String confluentPlatformVersion, int schemaPort) {
            this.network = network;
            this.kafkaHost = kafkaHost;
            this.confluentPlatformVersion = confluentPlatformVersion;
            this.schemaPort = schemaPort;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.network()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.kafkaHost()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.confluentPlatformVersion()));
            n = Statics.mix((int)n, (int)this.schemaPort());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Def)) return false;
            Def def = (Def)object;
            if (this.schemaPort() != def.schemaPort()) return false;
            Network network = this.network();
            Network network2 = def.network();
            if (network == null) {
                if (network2 != null) {
                    return false;
                }
            } else if (!network.equals(network2)) return false;
            String string = this.kafkaHost();
            String string2 = def.kafkaHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.confluentPlatformVersion();
            String string4 = def.confluentPlatformVersion();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!def.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Def;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Def";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "network";
                }
                case 1: {
                    return "kafkaHost";
                }
                case 2: {
                    return "confluentPlatformVersion";
                }
                case 3: {
                    return "schemaPort";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Network network() {
            return this.network;
        }

        public String kafkaHost() {
            return this.kafkaHost;
        }

        public String confluentPlatformVersion() {
            return this.confluentPlatformVersion;
        }

        public int schemaPort() {
            return this.schemaPort;
        }

        public SchemaRegistryContainer createContainer() {
            return new SchemaRegistryContainer(this.network(), this.kafkaHost(), this.confluentPlatformVersion(), this.schemaPort());
        }

        public Def copy(Network network, String kafkaHost, String confluentPlatformVersion, int schemaPort) {
            return new Def(network, kafkaHost, confluentPlatformVersion, schemaPort);
        }

        public Network copy$default$1() {
            return this.network();
        }

        public String copy$default$2() {
            return this.kafkaHost();
        }

        public String copy$default$3() {
            return this.confluentPlatformVersion();
        }

        public int copy$default$4() {
            return this.schemaPort();
        }

        public Network _1() {
            return this.network();
        }

        public String _2() {
            return this.kafkaHost();
        }

        public String _3() {
            return this.confluentPlatformVersion();
        }

        public int _4() {
            return this.schemaPort();
        }
    }
}

