/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String SERVICE_HOST = "beanstalk.service.host";
    private static final String SERVICE_PORT = "beanstalk.service.port";
    private static final String OPERATION_TIMEOUT = "beanstalk.operation.timeout";
    private static final String CONNECT_TIMEOUT = "beanstalk.connect.timeout";
    private static final String READ_TIMEOUT = "beanstalk.read.timeout";
    private static final String JOB_MAXSIZE = "beanstalk.job.maxSize";
    private static final String PROTOCOL_CHARSET = "beanstalk.protocol.charset";
    private final Properties properties = new Properties();

    public Configuration() {
    }

    public Configuration(Configuration other) {
        this.merge(other);
    }

    public Configuration(String configLocation) {
        if (configLocation == null) {
            throw new IllegalArgumentException("configLocation is null");
        }
        this.loadConfiguration(configLocation);
    }

    public Configuration merge(Configuration other) {
        if (other != null) {
            this.properties.putAll((Map<?, ?>)other.properties);
        }
        return this;
    }

    public void writeConfiguration(OutputStream out) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element conf = doc.createElement("configuration");
            doc.appendChild(conf);
            Enumeration<Object> e = this.properties.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object object = this.properties.get(name);
                String value = null;
                if (!(object instanceof String)) continue;
                value = (String)object;
                Element propNode = doc.createElement("property");
                conf.appendChild(propNode);
                Element nameNode = doc.createElement("name");
                nameNode.appendChild(doc.createTextNode(name));
                propNode.appendChild(nameNode);
                Element valueNode = doc.createElement("value");
                valueNode.appendChild(doc.createTextNode(value));
                propNode.appendChild(valueNode);
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadConfiguration(String location) {
        InputStream stream = this.getResourceStream(location);
        if (stream == null) {
            throw new IllegalArgumentException("can't find out configuration [" + location + "] from classpath.");
        }
        try {
            this.properties.putAll((Map<?, ?>)this.loadResource(stream));
        }
        catch (Exception e) {
            throw new IllegalStateException("can't load configuration [" + location + "]", e);
        }
    }

    private InputStream getResourceStream(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = Configuration.class.getClassLoader();
        }
        return classLoader.getResourceAsStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadResource(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setIgnoringComments(true);
        builderFactory.setIgnoringElementContentWhitespace(true);
        builderFactory.setNamespaceAware(true);
        try {
            builderFactory.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException e) {
            LOG.error("Failed to set setXIncludeAware(true) for parser " + builderFactory + ":" + e, (Throwable)e);
        }
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document doc = null;
        try {
            doc = builder.parse(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        Element root = doc.getDocumentElement();
        if (!"configuration".equals(root.getTagName())) {
            LOG.error("bad config file: top-level element not <configuration>");
            throw new IllegalStateException("bad config file: top-level element not <configuration>");
        }
        Properties properties = new Properties();
        Configuration.parseConfig(properties, root);
        return properties;
    }

    private static void parseConfig(Properties properties, Element root) {
        NodeList props = root.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Node propNode = props.item(i);
            if (!(propNode instanceof Element)) continue;
            Element prop = (Element)propNode;
            if ("configuration".equals(prop.getTagName())) {
                Configuration.parseConfig(properties, prop);
                continue;
            }
            if (!"property".equals(prop.getTagName())) {
                LOG.warn("bad config file: element not <property>,skip this element {}", (Object)prop);
                continue;
            }
            NodeList fields = prop.getChildNodes();
            String attr = null;
            String value = null;
            for (int j = 0; j < fields.getLength(); ++j) {
                Node fieldNode = fields.item(j);
                if (!(fieldNode instanceof Element)) continue;
                Element field = (Element)fieldNode;
                if ("name".equals(field.getTagName()) && field.hasChildNodes()) {
                    attr = ((Text)field.getFirstChild()).getData().trim();
                }
                if (!"value".equals(field.getTagName()) || !field.hasChildNodes()) continue;
                value = ((Text)field.getFirstChild()).getData();
                value = Configuration.resolvePlaceholders(value);
            }
            if (attr == null || value == null) continue;
            properties.setProperty(attr, value);
        }
    }

    private static String resolvePlaceholders(String text) {
        StringBuilder buf = new StringBuilder(text);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                int nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                try {
                    String propVal = System.getProperty(placeholder);
                    if (propVal == null) {
                        propVal = System.getenv(placeholder);
                    }
                    if (propVal != null) {
                        buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                        nextIndex = startIndex + propVal.length();
                    } else {
                        System.err.println("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: neither system property nor environment variable found");
                    }
                }
                catch (Throwable ex) {
                    System.err.println("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: " + ex);
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    protected String get(String name) {
        return this.properties.getProperty(name);
    }

    protected String get(String name, String defaultValue) {
        String ret = this.properties.getProperty(name);
        return ret == null ? defaultValue : ret;
    }

    protected void set(String name, String value) {
        this.properties.setProperty(name, value);
    }

    protected int getInt(String name, int defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Integer.parseInt(hexString, 16);
            }
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    protected long getLong(String name, long defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            String hexString = this.getHexDigits(valueString);
            if (hexString != null) {
                return Long.parseLong(hexString, 16);
            }
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        String hexString = null;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    protected float getFloat(String name, float defaultValue) {
        String valueString = this.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    protected void setFloat(String name, float value) {
        this.set(name, Float.toString(value));
    }

    protected boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    protected void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public String getServiceHost() {
        return this.get(SERVICE_HOST);
    }

    public void setServiceHost(String host) {
        this.set(SERVICE_HOST, host);
    }

    public int getServicePort() {
        return this.getInt(SERVICE_PORT, 11300);
    }

    public void setServicePort(int port) {
        this.setInt(SERVICE_PORT, port);
    }

    public int getJobMaxSize() {
        return this.getInt(JOB_MAXSIZE, 65536);
    }

    public void setJobMaxSize(int jobMaxSize) {
        this.setInt(JOB_MAXSIZE, jobMaxSize);
    }

    public int getOperationTimeout() {
        return this.getInt(OPERATION_TIMEOUT, 10);
    }

    public void setOperationTimeout(int operationTimeout) {
        this.setInt(OPERATION_TIMEOUT, operationTimeout);
    }

    public int getConnectTimeout() {
        return this.getInt(CONNECT_TIMEOUT, 3000);
    }

    public void setConnectTimeout(int timeout) {
        this.setInt(CONNECT_TIMEOUT, timeout);
    }

    public int getReadTimeout() {
        return this.getInt(READ_TIMEOUT, 3000);
    }

    public void setReadTimeout(int timeout) {
        this.setInt(READ_TIMEOUT, timeout);
    }

    public String getProtocolCharset() {
        return this.get(PROTOCOL_CHARSET, "ASCII");
    }

    public String toString() {
        return this.properties.toString();
    }
}

