/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal;

import com.dinstone.beanstalkc.ConnectionException;
import com.dinstone.beanstalkc.internal.Connection;
import com.dinstone.beanstalkc.internal.ConnectionInitializer;
import com.dinstone.beanstalkc.internal.Connector;
import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.SessionUtil;
import com.dinstone.beanstalkc.internal.operation.Operation;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;

public class DefaultConnection
implements Connection {
    private boolean closed;
    private IoSession ioSession;
    private final Connector connector;
    private final ConnectionInitializer initializer;

    public DefaultConnection(Connector connector, ConnectionInitializer initializer) {
        this.connector = connector;
        this.initializer = initializer;
    }

    @Override
    public synchronized <T> OperationFuture<T> handle(final Operation<T> operation) {
        this.connect();
        SessionUtil.getOperationQueue(this.ioSession).add(operation);
        WriteFuture writeFuture = this.ioSession.write(operation);
        writeFuture.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

            public void operationComplete(WriteFuture future) {
                if (!future.isWritten()) {
                    if (DefaultConnection.this.ioSession != null) {
                        SessionUtil.getOperationQueue(DefaultConnection.this.ioSession).remove(operation);
                    }
                    operation.getOperationFuture().setException(future.getException());
                }
            }
        });
        return operation.getOperationFuture();
    }

    @Override
    public synchronized void close() {
        this.destroy();
        this.closed = true;
    }

    public synchronized void destroy() {
        if (this.isConnected()) {
            this.ioSession.close(true);
        }
        this.ioSession = null;
    }

    private synchronized void connect() {
        if (this.closed) {
            throw new ConnectionException("connection is closed");
        }
        if (!this.isConnected()) {
            this.ioSession = this.connector.createSession();
            try {
                if (this.initializer != null) {
                    this.initializer.initConnection(this);
                }
            }
            catch (Exception e) {
                this.ioSession.close(true);
                this.ioSession = null;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new ConnectionException("can't init connection", e);
            }
        }
    }

    private boolean isConnected() {
        return this.ioSession != null && this.ioSession.isConnected();
    }
}

