/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.codec;

import com.dinstone.beanstalkc.UnknownCommandException;
import com.dinstone.beanstalkc.internal.SessionUtil;
import com.dinstone.beanstalkc.internal.operation.Operation;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Queue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;

public class OperationDecoder
extends CumulativeProtocolDecoder {
    private Charset charset;
    private String delimiter;
    private IoBuffer delimBuf;

    public OperationDecoder(Charset charset) {
        this(charset, "\r\n");
    }

    public OperationDecoder(Charset charset, String delimiter) {
        this.charset = charset;
        this.delimiter = delimiter;
        IoBuffer tmp = IoBuffer.allocate((int)2).setAutoExpand(true);
        try {
            tmp.putString((CharSequence)this.delimiter, charset.newEncoder());
            tmp.flip();
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        this.delimBuf = tmp;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        Operation<?> operation = SessionUtil.getOperationQueue(session).peek();
        if (operation == null) {
            throw new UnknownCommandException("unknown command");
        }
        int expect = operation.expect();
        if (expect == 0) {
            return this.parseStatusLine(session, in, out);
        }
        return this.parseDataBody(session, in, out, expect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseDataBody(IoSession session, IoBuffer in, ProtocolDecoderOutput out, int expect) {
        int delimLen = this.delimBuf.limit();
        int len = expect + delimLen;
        if (in.remaining() >= len) {
            int position = in.position();
            int limit = in.limit();
            try {
                in.limit(position + len);
                this.parse(session, in.slice(), out);
            }
            finally {
                in.limit(limit);
                in.position(position + len);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseStatusLine(IoSession session, IoBuffer in, ProtocolDecoderOutput out) {
        int start = in.position();
        int previous = 0;
        while (in.hasRemaining()) {
            byte current = in.get();
            if (previous == 13 && current == 10) {
                int position = in.position();
                int limit = in.limit();
                try {
                    in.position(start);
                    in.limit(position - 2);
                    this.parse(session, in.slice(), out);
                }
                finally {
                    in.limit(limit);
                    in.position(position);
                }
                return true;
            }
            previous = current;
        }
        in.position(start);
        return false;
    }

    private void parse(IoSession session, IoBuffer in, ProtocolDecoderOutput out) {
        Queue<Operation<?>> queue = SessionUtil.getOperationQueue(session);
        Operation<?> operation = queue.peek();
        boolean finish = operation.parseReply(this.charset, in);
        if (finish) {
            out.write(operation);
            queue.remove();
        }
    }
}

