/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuryOperation
extends AbstractOperation<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(BuryOperation.class);

    public BuryOperation(long id, int priority) {
        super(new OperationFuture());
        this.command = "bury " + id + " " + priority;
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        try {
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            if (line.startsWith("BURIED")) {
                this.future.setResult(true);
                return true;
            }
            if (line.startsWith("NOT_FOUND")) {
                this.future.setResult(false);
                return true;
            }
            this.exceptionHandler(line);
        }
        catch (Exception e) {
            this.future.setException(e);
        }
        return true;
    }
}

