/*
 * Decompiled with CFR 0.152.
 */
package com.dinstone.beanstalkc.internal.operation;

import com.dinstone.beanstalkc.internal.OperationFuture;
import com.dinstone.beanstalkc.internal.YamlUtil;
import com.dinstone.beanstalkc.internal.operation.AbstractOperation;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsOperation
extends AbstractOperation<Map<String, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(StatsOperation.class);
    private int length;

    public StatsOperation() {
        super(new OperationFuture());
        this.command = "stats";
    }

    public StatsOperation(long jobId) {
        super(new OperationFuture());
        this.command = "stats-job " + jobId;
    }

    public StatsOperation(String tubeName) {
        super(new OperationFuture());
        this.command = "stats-tube " + tubeName;
    }

    @Override
    public boolean parseReply(Charset charset, IoBuffer in) {
        try {
            if (this.length > 0) {
                this.future.setResult(YamlUtil.yaml2Map(charset, in));
                return true;
            }
            String line = in.getString(charset.newDecoder());
            LOG.debug("command is [{}], reply is [{}]", (Object)this.command, (Object)line);
            if (line.startsWith("NOT_FOUND")) {
                this.future.setResult(null);
                return true;
            }
            if (line.startsWith("OK")) {
                String[] tmp = line.split("\\s+");
                this.length = Integer.parseInt(tmp[1]);
                return false;
            }
            this.exceptionHandler(line);
        }
        catch (Exception e) {
            this.future.setException(e);
        }
        return true;
    }

    @Override
    public int expect() {
        return this.length;
    }
}

