/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj;

import com.diozero.ws281xj.LedDriverInterface;
import com.diozero.ws281xj.PixelColour;

public class PixelAnimations {
    public static void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void colourWipe(LedDriverInterface ledDriverInterface, int n, int n2) {
        for (int i = 0; i < ledDriverInterface.getNumPixels(); ++i) {
            ledDriverInterface.setPixelColour(i, n);
            ledDriverInterface.render();
            PixelAnimations.delay(n2);
        }
    }

    public static void rainbow(LedDriverInterface ledDriverInterface, int n) {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < ledDriverInterface.getNumPixels(); ++j) {
                ledDriverInterface.setPixelColour(j, PixelColour.wheel(j + i & 0xFF));
            }
            ledDriverInterface.render();
            PixelAnimations.delay(n);
        }
    }

    public static void rainbowCycle(LedDriverInterface ledDriverInterface, int n) {
        for (int i = 0; i < 1280; ++i) {
            for (int j = 0; j < ledDriverInterface.getNumPixels(); ++j) {
                ledDriverInterface.setPixelColour(j, PixelColour.wheel(j * 256 / ledDriverInterface.getNumPixels() + i & 0xFF));
            }
            ledDriverInterface.render();
            PixelAnimations.delay(n);
        }
    }

    public static void theatreChase(LedDriverInterface ledDriverInterface, int n, int n2) {
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n3;
                for (n3 = 0; n3 < ledDriverInterface.getNumPixels(); n3 += 3) {
                    ledDriverInterface.setPixelColour(n3 + j, n);
                }
                ledDriverInterface.render();
                PixelAnimations.delay(n2);
                for (n3 = 0; n3 < ledDriverInterface.getNumPixels(); n3 += 3) {
                    ledDriverInterface.setPixelColour(n3 + j, 0);
                }
            }
        }
    }

    public static void theatreChaseRainbow(LedDriverInterface ledDriverInterface, int n) {
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n2;
                for (n2 = 0; n2 < ledDriverInterface.getNumPixels(); n2 += 3) {
                    ledDriverInterface.setPixelColour(n2 + j, PixelColour.wheel((n2 + i) % 255));
                }
                ledDriverInterface.render();
                PixelAnimations.delay(n);
                for (n2 = 0; n2 < ledDriverInterface.getNumPixels(); n2 += 3) {
                    ledDriverInterface.setPixelColour(n2 + j, 0);
                }
            }
        }
    }

    public static void demo(LedDriverInterface ledDriverInterface) {
        System.out.println("colourWipe - red");
        PixelAnimations.colourWipe(ledDriverInterface, PixelColour.createColourRGB(255, 0, 0), 50);
        System.out.println("colourWipe - green");
        PixelAnimations.colourWipe(ledDriverInterface, PixelColour.createColourRGB(0, 255, 0), 50);
        System.out.println("colourWipe - blue");
        PixelAnimations.colourWipe(ledDriverInterface, PixelColour.createColourRGB(0, 0, 255), 50);
        System.out.println("theatreChase - white");
        PixelAnimations.theatreChase(ledDriverInterface, PixelColour.createColourRGB(127, 127, 127), 50);
        System.out.println("theatreChase - red");
        PixelAnimations.theatreChase(ledDriverInterface, PixelColour.createColourRGB(127, 0, 0), 50);
        System.out.println("theatreChase - blue");
        PixelAnimations.theatreChase(ledDriverInterface, PixelColour.createColourRGB(0, 0, 127), 50);
        System.out.println("rainbow");
        PixelAnimations.rainbow(ledDriverInterface, 20);
        System.out.println("rainbowCycle");
        PixelAnimations.rainbowCycle(ledDriverInterface, 20);
    }
}

