/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj.apa102;

import com.diozero.api.SpiDevice;
import com.diozero.ws281xj.LedDriverInterface;
import java.util.Arrays;

public class Apa102LedDriver
implements LedDriverInterface {
    private static final byte APA_START_DATA_BYTE = 0;
    private static final byte APA_RESET_DATA_BYTE = 0;
    private static final byte APA_END_DATA_BYTE = 0;
    private SpiDevice device;
    private int brightness;
    private int[] leds;
    private byte[] spiBuffer;

    public Apa102LedDriver(int n, int n2, int n3, int n4, int n5) {
        this.device = SpiDevice.builder((int)n2).setController(n).setFrequency(n3).build();
        this.brightness = n5 & 0x1F;
        this.leds = new int[n4];
        this.spiBuffer = new byte[4 + 4 * n4 + (n4 + 63) / 64 * 4];
    }

    @Override
    public void close() {
        this.allOff();
        this.device.close();
    }

    @Override
    public int getNumPixels() {
        return this.leds.length;
    }

    @Override
    public void render() {
        this.device.write(this.spiBuffer);
    }

    @Override
    public void allOff() {
        Arrays.fill(this.leds, 0);
        Arrays.fill(this.spiBuffer, (byte)0);
        this.render();
    }

    @Override
    public int getPixelColour(int n) {
        return this.leds[n];
    }

    @Override
    public void setPixelColour(int n, int n2) {
        this.leds[n] = n2;
        int n3 = 4 * (1 + n);
        this.spiBuffer[n3] = (byte)(0xE0 | this.brightness);
        this.spiBuffer[n3 + 1] = (byte)this.getBlueComponent(n);
        this.spiBuffer[n3 + 2] = (byte)this.getGreenComponent(n);
        this.spiBuffer[n3 + 3] = (byte)this.getRedComponent(n);
    }
}

