/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj.rpiws281x;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class LibraryUtil {
    private static final String OS_NAME = System.getProperty("os.name").replace(" ", "").toLowerCase();
    private static String OS_ARCH = System.getProperty("os.arch").toLowerCase();
    private static final String LINUX_CPUINFO_FILE = "/proc/cpuinfo";
    private static final String ARMV6_CPU_MODEL_NAME = "armv6";
    private static final String ARMV7_CPU_MODEL_NAME = "armv7";

    public static String getCpuArch() {
        String string2 = OS_ARCH;
        try {
            Path path = Paths.get(LINUX_CPUINFO_FILE, new String[0]);
            if (path.toFile().exists() && path.toFile().canRead() && (string2 = Files.lines(path).filter(string -> string.startsWith("model name")).map(string -> string.split(":")[1].trim().split("[- ]")[0].trim().toLowerCase()).filter(string -> string.equals(ARMV6_CPU_MODEL_NAME) || string.equals(ARMV7_CPU_MODEL_NAME)).findFirst().orElse(OS_ARCH)).equals("arm")) {
                string2 = ARMV6_CPU_MODEL_NAME;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public static String getLibExt() {
        switch (OS_NAME) {
            case "macosx": {
                return "dylib";
            }
            case "win": {
                return "dll";
            }
        }
        return "so";
    }

    public static boolean loadLibrary(String string, Class<?> clazz) {
        boolean bl = false;
        try {
            System.loadLibrary(string);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!bl) {
            String string2 = LibraryUtil.getLibExt();
            String string3 = String.format("/lib/%s-%s/lib%s.%s", OS_NAME, LibraryUtil.getCpuArch(), string, string2);
            try (InputStream inputStream = clazz.getResourceAsStream(string3);){
                if (inputStream == null) {
                    System.err.println("Error: unable to find '" + string3 + "' in the JAR file");
                } else {
                    Path path = Files.createTempFile("lib" + string, string2, new FileAttribute[0]);
                    path.toFile().deleteOnExit();
                    Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                    Runtime.getRuntime().load(path.toString());
                    bl = true;
                    path.toFile().delete();
                }
            }
            catch (Throwable throwable) {
                System.err.println("Error loading library from classpath '" + string3 + "': " + throwable);
            }
        }
        return bl;
    }
}

