/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj.rpiws281x;

import com.diozero.ws281xj.LedDriverInterface;
import com.diozero.ws281xj.StripType;
import com.diozero.ws281xj.rpiws281x.LibraryUtil;
import com.diozero.ws281xj.rpiws281x.WS281xNative;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;

public class WS281x
implements LedDriverInterface {
    private static final int SIZE_OF_INT = 4;
    private static final int DEFAULT_FREQUENCY = 800000;
    private static final int DEFAULT_DMA_NUM = 5;
    private static final StripType DEFAULT_STRIP_TYPE = StripType.WS2812;
    private static final int DEFAULT_CHANNEL = 0;
    private static final String LIB_NAME = "ws281xj";
    private static AtomicBoolean loaded = new AtomicBoolean();
    private static final int SK6812_STRIP_RGBW = 0x18100800;
    private static final int SK6812_STRIP_RBGW = 0x18100008;
    private static final int SK6812_STRIP_GRBW = 0x18081000;
    private static final int SK6812_STRIP_GBRW = 0x18080010;
    private static final int SK6812_STRIP_BRGW = 0x18001008;
    private static final int SK6812_STRIP_BGRW = 0x18000810;
    private static final int SK6812_SHIFT_WMASK = -268435456;
    private static final int WS2811_STRIP_RGB = 0x100800;
    private static final int WS2811_STRIP_RBG = 0x100008;
    private static final int WS2811_STRIP_GRB = 528384;
    private static final int WS2811_STRIP_GBR = 524304;
    private static final int WS2811_STRIP_BRG = 4104;
    private static final int WS2811_STRIP_BGR = 2064;
    private static final int WS2812_STRIP = 528384;
    private static final int SK6812_STRIP = 528384;
    private static final int SK6812W_STRIP = 0x18081000;
    private ByteBuffer ch0LedBuffer;
    private int numPixels;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        AtomicBoolean atomicBoolean = loaded;
        synchronized (atomicBoolean) {
            if (!loaded.get()) {
                if (!LibraryUtil.loadLibrary(LIB_NAME, WS281x.class)) {
                    throw new RuntimeException("Error loading native library 'ws281xj'");
                }
                loaded.set(true);
                Runtime.getRuntime().addShutdownHook(new Thread(WS281xNative::terminate, "WS281x Shutdown Handler"));
            }
        }
    }

    public WS281x(int n, int n2, int n3) {
        this(800000, 5, n, n2, n3, DEFAULT_STRIP_TYPE, 0);
    }

    public WS281x(int n, int n2, int n3, int n4, int n5, StripType stripType) {
        this(800000, 5, n3, n4, n5, stripType, 0);
    }

    public WS281x(int n, int n2, int n3, int n4, int n5, StripType stripType, int n6) {
        WS281x.init();
        this.numPixels = n5;
        this.ch0LedBuffer = WS281xNative.initialise(n, n2, n3, n4, n5, WS281x.getRpiStripType(stripType), n6);
        if (this.ch0LedBuffer == null) {
            throw new RuntimeException("Error initialising the WS281x strip");
        }
        System.out.println("order=" + this.ch0LedBuffer.order());
        this.ch0LedBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void close() {
        System.out.println("close()");
        if (this.ch0LedBuffer != null) {
            this.allOff();
            this.ch0LedBuffer = null;
        }
        WS281xNative.terminate();
    }

    @Override
    public int getNumPixels() {
        return this.numPixels;
    }

    @Override
    public void render() {
        int n = WS281xNative.render();
        if (n != 0) {
            throw new RuntimeException("Error in render() - " + n);
        }
    }

    private void validatePixel(int n) {
        if (n < 0 || n >= this.numPixels) {
            throw new IllegalArgumentException("pixel must be 0.." + (this.numPixels - 1));
        }
    }

    @Override
    public void allOff() {
        for (int i = 0; i < this.numPixels; ++i) {
            this.setPixelColour(i, 0);
        }
        this.render();
    }

    @Override
    public int getPixelColour(int n) {
        this.validatePixel(n);
        return this.ch0LedBuffer.getInt(n * 4);
    }

    @Override
    public void setPixelColour(int n, int n2) {
        this.validatePixel(n);
        this.ch0LedBuffer.putInt(n * 4, n2);
    }

    private static int getRpiStripType(StripType stripType) {
        switch (stripType) {
            case SK6812_RGBW: {
                return 0x18100800;
            }
            case SK6812_RBGW: {
                return 0x18100008;
            }
            case SK6812_GRBW: {
                return 0x18081000;
            }
            case SK6812_GBRW: {
                return 0x18080010;
            }
            case SK6812_BRGW: {
                return 0x18001008;
            }
            case SK6812_BGRW: {
                return 0x18000810;
            }
            case WS2811_RGB: {
                return 0x100800;
            }
            case WS2811_RBG: {
                return 0x100008;
            }
            case WS2811_GRB: {
                return 528384;
            }
            case WS2811_GBR: {
                return 524304;
            }
            case WS2811_BRG: {
                return 4104;
            }
            case WS2811_BGR: {
                return 2064;
            }
        }
        return 528384;
    }
}

