/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj.sampleapps;

import com.diozero.util.SleepUtil;
import com.diozero.ws281xj.PixelAnimations;
import com.diozero.ws281xj.StripType;
import com.diozero.ws281xj.spi.WS281xSpi;
import org.tinylog.Logger;

public class WS281xSpiTest {
    public static void main(String[] stringArray) {
        StripType stripType = StripType.WS2812;
        int n = 60;
        if (stringArray.length > 0) {
            n = Integer.parseInt(stringArray[0]);
        }
        int n2 = 127;
        try (WS281xSpi wS281xSpi = new WS281xSpi(2, 0, stripType, n, n2);){
            Logger.debug((Object)"All off");
            wS281xSpi.allOff();
            SleepUtil.sleepMillis((long)500L);
            for (int i = 0; i < 5; ++i) {
                int n3;
                int n4;
                Logger.debug((Object)"Incremental red");
                int n5 = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    wS281xSpi.setPixelColourRGB(n4, n5, 0, 0);
                    n5 += 255 / n;
                }
                wS281xSpi.render();
                SleepUtil.sleepMillis((long)500L);
                Logger.debug((Object)"Incremental green");
                n4 = 0;
                for (n3 = 0; n3 < n; ++n3) {
                    wS281xSpi.setPixelColourRGB(n3, 0, n4, 0);
                    n4 += 255 / n;
                }
                wS281xSpi.render();
                SleepUtil.sleepMillis((long)500L);
                Logger.debug((Object)"Incremental blue");
                n3 = 0;
                for (int j = 0; j < n; ++j) {
                    wS281xSpi.setPixelColourRGB(j, 0, 0, n3);
                    n3 += 255 / n;
                }
                wS281xSpi.render();
                SleepUtil.sleepMillis((long)500L);
            }
            Logger.debug((Object)"All off");
            wS281xSpi.allOff();
            wS281xSpi.render();
            SleepUtil.sleepMillis((long)500L);
            PixelAnimations.demo(wS281xSpi);
        }
    }
}

