/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj.sampleapps;

import com.diozero.ws281xj.LedDriverInterface;
import com.diozero.ws281xj.PixelAnimations;
import com.diozero.ws281xj.PixelColour;
import com.diozero.ws281xj.rpiws281x.WS281x;

public class WS281xTest {
    public static void main(String[] stringArray) {
        int n = 10;
        int n2 = 64;
        int n3 = 60;
        System.out.println("Using GPIO " + n);
        try (WS281x wS281x = new WS281x(n, n2, n3);){
            WS281xTest.rainbowColours(wS281x);
            WS281xTest.test2(wS281x);
            WS281xTest.hsbTest(wS281x);
            WS281xTest.hslTest(wS281x);
            PixelAnimations.demo(wS281x);
        }
        catch (Throwable throwable) {
            System.out.println("Error: " + throwable);
            throwable.printStackTrace();
        }
    }

    private static void rainbowColours(LedDriverInterface ledDriverInterface) {
        System.out.println("rainbowColours()");
        int[] nArray = PixelColour.RAINBOW;
        for (int i = 0; i < 250; ++i) {
            for (int j = 0; j < ledDriverInterface.getNumPixels(); ++j) {
                ledDriverInterface.setPixelColour(j, nArray[(i + j) % nArray.length]);
            }
            ledDriverInterface.render();
            PixelAnimations.delay(50);
        }
    }

    private static void test2(LedDriverInterface ledDriverInterface) {
        int n;
        int n2;
        System.out.println("test2()");
        ledDriverInterface.allOff();
        int n3 = 20;
        System.out.println("Adding red...");
        for (n2 = 0; n2 < 256; n2 += 2) {
            for (n = 0; n < ledDriverInterface.getNumPixels(); ++n) {
                ledDriverInterface.setRedComponent(n, n2);
            }
            ledDriverInterface.render();
            PixelAnimations.delay(n3);
        }
        System.out.println("Adding green...");
        for (n2 = 0; n2 < 256; n2 += 2) {
            for (n = 0; n < ledDriverInterface.getNumPixels(); ++n) {
                ledDriverInterface.setGreenComponent(n, n2);
            }
            ledDriverInterface.render();
            PixelAnimations.delay(n3);
        }
        System.out.println("Adding blue...");
        for (n2 = 0; n2 < 256; n2 += 2) {
            for (n = 0; n < ledDriverInterface.getNumPixels(); ++n) {
                ledDriverInterface.setBlueComponent(n, n2);
            }
            ledDriverInterface.render();
            PixelAnimations.delay(n3);
        }
        ledDriverInterface.allOff();
    }

    private static void hsbTest(LedDriverInterface ledDriverInterface) {
        System.out.println("hsbTest()");
        float f = 0.5f;
        for (float f2 = 0.0f; f2 < 1.0f; f2 += 0.05f) {
            for (float f3 = 0.0f; f3 <= 1.0f; f3 += 0.05f) {
                for (int i = 0; i < ledDriverInterface.getNumPixels(); ++i) {
                    ledDriverInterface.setPixelColourHSB(i, f2, f3, f);
                }
                ledDriverInterface.render();
                PixelAnimations.delay(20);
            }
        }
    }

    private static void hslTest(LedDriverInterface ledDriverInterface) {
        System.out.println("hslTest()");
        float f = 0.5f;
        for (float f2 = 0.0f; f2 < 360.0f; f2 += 18.0f) {
            for (float f3 = 0.0f; f3 <= 1.0f; f3 += 0.05f) {
                for (int i = 0; i < ledDriverInterface.getNumPixels(); ++i) {
                    ledDriverInterface.setPixelColourHSL(i, f2, f3, f);
                }
                ledDriverInterface.render();
                PixelAnimations.delay(20);
            }
        }
    }
}

