/*
 * Decompiled with CFR 0.152.
 */
package com.diozero.ws281xj.spi;

import com.diozero.api.SpiDevice;
import com.diozero.util.SleepUtil;
import com.diozero.ws281xj.LedDriverInterface;
import com.diozero.ws281xj.StripType;
import java.util.Arrays;
import org.tinylog.Logger;

public class WS281xSpi
implements LedDriverInterface {
    private static final int LED_COLOURS = 4;
    private static final int LED_RESET_uS = 55;
    private static final int LED_RESET_WAIT_TIME = 300000;
    private static final byte SYMBOL_HIGH = 6;
    private static final byte SYMBOL_LOW = 4;
    private static final byte SYMBOL_HIGH_INV = 1;
    private static final byte SYMBOL_LOW_INV = 3;
    private SpiDevice device;
    private Protocol protocol;
    private StripType stripType;
    private int numLeds;
    private long lastRenderTime;
    private int renderWaitTime;
    private int brightness;
    private int[] leds;
    private byte[] gamma;
    private byte[] pixelRaw;

    public WS281xSpi(int n, int n2, StripType stripType, int n3, int n4) {
        this(n, n2, Protocol.PROTOCOL_800KHZ, stripType, n3, n4);
    }

    public WS281xSpi(int n, int n2, Protocol protocol, StripType stripType, int n3, int n4) {
        this.device = SpiDevice.builder((int)n2).setController(n).setFrequency(protocol.getFrequency() * 3).build();
        this.protocol = protocol;
        this.stripType = stripType;
        this.numLeds = n3;
        this.brightness = n4 & 0xFF;
        this.leds = new int[n3];
        this.gamma = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.gamma[i] = (byte)i;
        }
        this.pixelRaw = new byte[WS281xSpi.PCM_BYTE_COUNT(n3, protocol.getFrequency())];
        this.renderWaitTime = n3 * stripType.getColourCount() * 8 * 1250 + 300000;
    }

    @Override
    public void close() {
        Logger.trace((Object)"Turning all off before close");
        this.allOff();
        this.device.close();
    }

    @Override
    public int getNumPixels() {
        return this.numLeds;
    }

    @Override
    public int getPixelColour(int n) {
        return this.leds[n];
    }

    @Override
    public void setPixelColour(int n, int n2) {
        this.leds[n] = n2;
    }

    @Override
    public void render() {
        int n;
        int n2 = 7;
        int n3 = 0;
        int n4 = this.brightness + 1;
        int n5 = this.stripType.getColourCount();
        for (n = 0; n < this.numLeds; ++n) {
            byte[] byArray = new byte[]{this.gamma[(this.leds[n] >> this.stripType.getRedShift() & 0xFF) * n4 >> 8], this.gamma[(this.leds[n] >> this.stripType.getGreenShift() & 0xFF) * n4 >> 8], this.gamma[(this.leds[n] >> this.stripType.getBlueShift() & 0xFF) * n4 >> 8], this.gamma[(this.leds[n] >> this.stripType.getWhiteShift() & 0xFF) * n4 >> 8]};
            for (int i = 0; i < n5; ++i) {
                for (int j = 7; j >= 0; --j) {
                    int n6 = (byArray[i] & 1 << j) != 0 ? 6 : 4;
                    for (int k = 2; k >= 0; --k) {
                        int n7 = n3;
                        this.pixelRaw[n7] = (byte)(this.pixelRaw[n7] & ~(1 << n2));
                        if ((n6 & 1 << k) != 0) {
                            int n8 = n3;
                            this.pixelRaw[n8] = (byte)(this.pixelRaw[n8] | 1 << n2);
                        }
                        if (--n2 >= 0) continue;
                        ++n3;
                        n2 = 7;
                    }
                }
            }
        }
        if (this.lastRenderTime != 0L && this.renderWaitTime > (n = (int)(System.nanoTime() - this.lastRenderTime))) {
            SleepUtil.busySleep((long)(this.renderWaitTime - n));
        }
        this.device.write(this.pixelRaw);
        this.lastRenderTime = System.nanoTime();
    }

    @Override
    public void allOff() {
        Arrays.fill(this.leds, 0);
        this.render();
    }

    private static final int LED_BIT_COUNT(int n, int n2) {
        return n * 4 * 8 * 3 + 55 * (n2 * 3) / 1000000;
    }

    private static final int PCM_BYTE_COUNT(int n, int n2) {
        return (WS281xSpi.LED_BIT_COUNT(n, n2) >> 3 & 0xFFFFFFF8) + 4 + 4;
    }

    public static enum Protocol {
        PROTOCOL_800KHZ(800000),
        PROTOCOL_400KHZ(400000);

        int frequency;

        private Protocol(int n2) {
            this.frequency = n2;
        }

        public int getFrequency() {
            return this.frequency;
        }
    }
}

