/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.archive;

import com.dipien.byebyejetifier.archive.ArchiveFile;
import com.dipien.byebyejetifier.archive.ArchiveItem;
import com.dipien.byebyejetifier.archive.ArchiveItemVisitor;
import com.dipien.byebyejetifier.scanner.ScanResult;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\bH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/dipien/byebyejetifier/archive/Archive;", "Lcom/dipien/byebyejetifier/archive/ArchiveItem;", "relativePath", "Ljava/nio/file/Path;", "files", "", "(Ljava/nio/file/Path;Ljava/util/List;)V", "_files", "", "fileName", "", "getFileName", "()Ljava/lang/String;", "getFiles", "()Ljava/util/List;", "getRelativePath", "()Ljava/nio/file/Path;", "accept", "", "visitor", "Lcom/dipien/byebyejetifier/archive/ArchiveItemVisitor;", "scanResults", "Lcom/dipien/byebyejetifier/scanner/ScanResult;", "Builder", "Companion", "bye-bye-jetifier"})
public final class Archive
implements ArchiveItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path relativePath;
    @NotNull
    private final List<ArchiveItem> _files;
    @NotNull
    private final List<ArchiveItem> files;
    @NotNull
    private final String fileName;
    @NotNull
    private static final List<String> ARCHIVE_EXTENSIONS;

    public Archive(@NotNull Path relativePath, @NotNull List<? extends ArchiveItem> files) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.relativePath = relativePath;
        this._files = CollectionsKt.toMutableList((Collection)files);
        this.files = this._files;
        this.fileName = ((Object)this.getRelativePath().getFileName()).toString();
    }

    @Override
    @NotNull
    public Path getRelativePath() {
        return this.relativePath;
    }

    @NotNull
    public final List<ArchiveItem> getFiles() {
        return this.files;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void accept(@NotNull ArchiveItemVisitor visitor, @NotNull List<ScanResult> scanResults) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter(scanResults, (String)"scanResults");
        visitor.visit(this, scanResults);
    }

    static {
        Object[] objectArray = new String[]{".jar", ".zip", ".aar"};
        ARCHIVE_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/dipien/byebyejetifier/archive/Archive$Companion;", "", "()V", "ARCHIVE_EXTENSIONS", "", "", "getARCHIVE_EXTENSIONS", "()Ljava/util/List;", "bye-bye-jetifier"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getARCHIVE_EXTENSIONS() {
            return ARCHIVE_EXTENSIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/dipien/byebyejetifier/archive/Archive$Builder;", "", "()V", "extract", "Lcom/dipien/byebyejetifier/archive/Archive;", "archiveFile", "Ljava/io/File;", "recursive", "", "extractArchive", "inputStream", "Ljava/io/InputStream;", "relativePath", "Ljava/nio/file/Path;", "extractFile", "Lcom/dipien/byebyejetifier/archive/ArchiveFile;", "zipIn", "Ljava/util/zip/ZipInputStream;", "isArchive", "zipEntry", "Ljava/util/zip/ZipEntry;", "bye-bye-jetifier"})
    public static final class Builder {
        @NotNull
        public static final Builder INSTANCE = new Builder();

        private Builder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Archive extract(@NotNull File archiveFile, boolean recursive) throws IOException {
            Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
            FileInputStream inputStream = new FileInputStream(archiveFile);
            Closeable closeable = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl3 = false;
                InputStream inputStream2 = it;
                Path path = archiveFile.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"archiveFile.toPath()");
                Archive archive = INSTANCE.extractArchive(inputStream2, path, recursive);
                return archive;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public static /* synthetic */ Archive extract$default(Builder builder, File file, boolean bl, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                bl = true;
            }
            return builder.extract(file, bl);
        }

        private final Archive extractArchive(InputStream inputStream, Path relativePath, boolean recursive) throws IOException {
            ZipInputStream zipIn = new ZipInputStream(inputStream);
            boolean bl = false;
            List files = new ArrayList();
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    Path entryPath = Paths.get(entry.getName(), new String[0]);
                    if (this.isArchive(entry) && recursive) {
                        InputStream inputStream2 = zipIn;
                        Intrinsics.checkNotNullExpressionValue((Object)entryPath, (String)"entryPath");
                        files.add(this.extractArchive(inputStream2, entryPath, recursive));
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)entryPath, (String)"entryPath");
                        files.add(this.extractFile(zipIn, entryPath));
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            return new Archive(relativePath, CollectionsKt.toList((Iterable)files));
        }

        private final ArchiveFile extractFile(ZipInputStream zipIn, Path relativePath) throws IOException {
            byte[] data = ByteStreamsKt.readBytes((InputStream)zipIn);
            return new ArchiveFile(relativePath, data);
        }

        private final boolean isArchive(ZipEntry zipEntry) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = Companion.getARCHIVE_EXTENSIONS();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string = zipEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zipEntry.name");
                        if (!StringsKt.endsWith((String)string, (String)it, (boolean)true)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }
}

