/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.core;

import com.dipien.byebyejetifier.common.LoggerHelper;
import com.dipien.byebyejetifier.core.config.Config;
import com.dipien.byebyejetifier.core.type.JavaType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/dipien/byebyejetifier/core/TypeRewriter;", "", "config", "Lcom/dipien/byebyejetifier/core/config/Config;", "(Lcom/dipien/byebyejetifier/core/config/Config;)V", "rewriteType", "Lcom/dipien/byebyejetifier/core/type/JavaType;", "type", "bye-bye-jetifier"})
public final class TypeRewriter {
    @NotNull
    private final Config config;

    public TypeRewriter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @Nullable
    public final JavaType rewriteType(@NotNull JavaType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        JavaType result = this.config.getTypesMap().mapType(type);
        if (result != null) {
            LoggerHelper.INSTANCE.debug("Map: " + type + " -> " + result);
            return result;
        }
        if (!this.config.isEligibleForRewrite(type)) {
            return type;
        }
        JavaType rulesResult = this.config.getRulesMap().rewriteType(type);
        if (rulesResult != null) {
            LoggerHelper.INSTANCE.debug("Using fallback: " + type + " -> " + rulesResult);
            return rulesResult;
        }
        return null;
    }
}

