/*
 * Decompiled with CFR 0.152.
 */
package com.dipien.byebyejetifier.scanner;

import com.dipien.byebyejetifier.archive.ArchiveFile;
import com.dipien.byebyejetifier.common.LoggerHelper;
import com.dipien.byebyejetifier.common.StringExtensionsKt;
import com.dipien.byebyejetifier.core.TypeRewriter;
import com.dipien.byebyejetifier.core.config.Config;
import com.dipien.byebyejetifier.core.type.JavaType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/dipien/byebyejetifier/scanner/ScannerContext;", "", "config", "Lcom/dipien/byebyejetifier/core/config/Config;", "excludedFilesFromScanning", "", "", "(Lcom/dipien/byebyejetifier/core/config/Config;Ljava/util/List;)V", "getConfig", "()Lcom/dipien/byebyejetifier/core/config/Config;", "typeRewriter", "Lcom/dipien/byebyejetifier/core/TypeRewriter;", "getTypeRewriter", "()Lcom/dipien/byebyejetifier/core/TypeRewriter;", "isExcludedFileFromScanning", "", "archiveFile", "Lcom/dipien/byebyejetifier/archive/ArchiveFile;", "reportNoMappingFoundFailure", "", "tag", "type", "Lcom/dipien/byebyejetifier/core/type/JavaType;", "bye-bye-jetifier"})
public final class ScannerContext {
    @NotNull
    private final Config config;
    @NotNull
    private final List<String> excludedFilesFromScanning;
    @NotNull
    private final TypeRewriter typeRewriter;

    public ScannerContext(@NotNull Config config, @NotNull List<String> excludedFilesFromScanning) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(excludedFilesFromScanning, (String)"excludedFilesFromScanning");
        this.config = config;
        this.excludedFilesFromScanning = excludedFilesFromScanning;
        this.typeRewriter = new TypeRewriter(this.config);
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final TypeRewriter getTypeRewriter() {
        return this.typeRewriter;
    }

    public final boolean isExcludedFileFromScanning(@NotNull ArchiveFile archiveFile) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
            Iterable $this$any$iv = this.excludedFilesFromScanning;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)((Object)archiveFile.getRelativePath()).toString(), (String)StringExtensionsKt.toFilePath(it), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void reportNoMappingFoundFailure(@NotNull String tag, @NotNull JavaType type) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        LoggerHelper.INSTANCE.warn(Intrinsics.stringPlus((String)"No mapping for: ", (Object)type), tag);
    }
}

