/*
 * Decompiled with CFR 0.152.
 */
package com.semanticversion;

import com.semanticversion.SemanticVersionConfig;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u0000 42\u00020\u0001:\u00014B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\nB\u0017\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020-J\u0006\u0010/\u001a\u00020-J\u0010\u00100\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u00101\u001a\u00020-2\u0006\u0010\"\u001a\u00020\bH\u0002J\b\u00102\u001a\u00020\bH\u0016J\b\u00103\u001a\u00020-H\u0002R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0016\"\u0004\b\u001c\u0010\u0018R\u001e\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010\"\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010%R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b&\u0010\u001e\"\u0004\b'\u0010 R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b(\u0010\u001e\"\u0004\b)\u0010 R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b*\u0010\u001e\"\u0004\b+\u0010 \u00a8\u00065"}, d2={"Lcom/semanticversion/Version;", "", "versionMajor", "", "versionMinor", "versionPatch", "(III)V", "version", "", "maximumVersion", "(Ljava/lang/String;Ljava/lang/Integer;)V", "baseVersion", "config", "Lcom/semanticversion/SemanticVersionConfig;", "(Ljava/lang/String;Lcom/semanticversion/SemanticVersionConfig;)V", "getBaseVersion", "()Ljava/lang/String;", "defaultMaximumVersion", "getDefaultMaximumVersion", "()I", "isAlpha", "", "()Z", "setAlpha", "(Z)V", "isBeta", "setBeta", "isSnapshot", "setSnapshot", "getMaximumVersion", "()Ljava/lang/Integer;", "setMaximumVersion", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "versionClassifier", "getVersionClassifier", "setVersionClassifier", "(Ljava/lang/String;)V", "getVersionMajor", "setVersionMajor", "getVersionMinor", "setVersionMinor", "getVersionPatch", "setVersionPatch", "incrementMajor", "", "incrementMinor", "incrementPatch", "parseBaseVersion", "parseVersionClassifier", "toString", "validateBaseVersion", "Companion", "semantic-version"})
public class Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Integer versionMajor;
    @Nullable
    private Integer versionMinor;
    @Nullable
    private Integer versionPatch;
    @Nullable
    private String versionClassifier;
    private boolean isSnapshot;
    private boolean isBeta;
    private boolean isAlpha;
    @Nullable
    private Integer maximumVersion;
    @NotNull
    public static final String VERSION_CLASSIFIER_SEPARATOR = "-";
    @NotNull
    public static final String SNAPSHOT_CLASSIFIER = "SNAPSHOT";
    @NotNull
    public static final String BETA_CLASSIFIER = "BETA";
    @NotNull
    public static final String ALPHA_CLASSIFIER = "ALPHA";
    @NotNull
    public static final String BASE_VERSION_SEPARATOR = ".";

    @Nullable
    public final Integer getVersionMajor() {
        return this.versionMajor;
    }

    public final void setVersionMajor(@Nullable Integer n) {
        this.versionMajor = n;
    }

    @Nullable
    public final Integer getVersionMinor() {
        return this.versionMinor;
    }

    public final void setVersionMinor(@Nullable Integer n) {
        this.versionMinor = n;
    }

    @Nullable
    public final Integer getVersionPatch() {
        return this.versionPatch;
    }

    public final void setVersionPatch(@Nullable Integer n) {
        this.versionPatch = n;
    }

    @Nullable
    public final String getVersionClassifier() {
        return this.versionClassifier;
    }

    public final void setVersionClassifier(@Nullable String string) {
        this.versionClassifier = string;
    }

    public final boolean isSnapshot() {
        return this.isSnapshot;
    }

    public final void setSnapshot(boolean bl) {
        this.isSnapshot = bl;
    }

    public final boolean isBeta() {
        return this.isBeta;
    }

    public final void setBeta(boolean bl) {
        this.isBeta = bl;
    }

    public final boolean isAlpha() {
        return this.isAlpha;
    }

    public final void setAlpha(boolean bl) {
        this.isAlpha = bl;
    }

    @Nullable
    public final Integer getMaximumVersion() {
        return this.maximumVersion;
    }

    public final void setMaximumVersion(@Nullable Integer n) {
        this.maximumVersion = n;
    }

    protected int getDefaultMaximumVersion() {
        return 99;
    }

    @NotNull
    public final String getBaseVersion() {
        return "" + this.versionMajor + '.' + this.versionMinor + '.' + this.versionPatch;
    }

    public Version(int versionMajor, int versionMinor, int versionPatch) {
        this.isSnapshot = true;
        this.maximumVersion = this.getDefaultMaximumVersion();
        this.versionMajor = versionMajor;
        this.versionMinor = versionMinor;
        this.versionPatch = versionPatch;
        this.validateBaseVersion();
    }

    public Version(@NotNull String version, @Nullable Integer maximumVersion) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.isSnapshot = true;
        Integer n = maximumVersion;
        if (n == null) {
            n = this.getDefaultMaximumVersion();
        }
        this.maximumVersion = n;
        String[] stringArray = new String[]{VERSION_CLASSIFIER_SEPARATOR};
        List split = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String baseVersion = (String)split.get(0);
        this.parseBaseVersion(baseVersion);
        if (split.size() > 1) {
            String string = this.versionClassifier = (String)split.get(1);
            Intrinsics.checkNotNull((Object)string);
            this.parseVersionClassifier(string);
        } else {
            this.isSnapshot = false;
            this.isAlpha = false;
            this.isBeta = false;
        }
    }

    public /* synthetic */ Version(String string, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(string, n);
    }

    public Version(@NotNull String baseVersion, @NotNull SemanticVersionConfig config) {
        Intrinsics.checkNotNullParameter((Object)baseVersion, (String)"baseVersion");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.isSnapshot = true;
        Integer n = config.getMaximumVersion();
        if (n == null) {
            n = this.getDefaultMaximumVersion();
        }
        this.maximumVersion = n;
        this.parseBaseVersion(baseVersion);
        this.versionClassifier = config.getVersionClassifier();
        if (this.versionClassifier == null) {
            if (Intrinsics.areEqual((Object)config.getAlpha(), (Object)true)) {
                this.versionClassifier = ALPHA_CLASSIFIER;
                this.isAlpha = true;
                this.isBeta = false;
                this.isSnapshot = false;
            } else if (Intrinsics.areEqual((Object)config.getBeta(), (Object)true)) {
                this.versionClassifier = BETA_CLASSIFIER;
                this.isAlpha = false;
                this.isBeta = true;
                this.isSnapshot = false;
            } else if (Intrinsics.areEqual((Object)config.getSnapshot(), (Object)true) || config.getSnapshot() == null) {
                this.versionClassifier = SNAPSHOT_CLASSIFIER;
                this.isAlpha = false;
                this.isBeta = false;
                this.isSnapshot = true;
            } else {
                this.isAlpha = false;
                this.isBeta = false;
                this.isSnapshot = false;
            }
        } else {
            String string = this.versionClassifier;
            Intrinsics.checkNotNull((Object)string);
            this.parseVersionClassifier(string);
        }
    }

    private final void parseVersionClassifier(String versionClassifier) {
        switch (versionClassifier) {
            case "ALPHA": {
                this.isSnapshot = false;
                this.isBeta = false;
                this.isAlpha = true;
                break;
            }
            case "BETA": {
                this.isSnapshot = false;
                this.isBeta = true;
                this.isAlpha = false;
                break;
            }
            case "SNAPSHOT": {
                this.isSnapshot = true;
                this.isBeta = false;
                this.isAlpha = false;
                break;
            }
            default: {
                this.isSnapshot = false;
                this.isBeta = false;
                this.isAlpha = false;
            }
        }
    }

    private final void parseBaseVersion(String baseVersion) {
        String[] stringArray = new String[]{BASE_VERSION_SEPARATOR};
        List versionSplit = StringsKt.split$default((CharSequence)baseVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (versionSplit.size() != 3) {
            throw new RuntimeException("The version [" + baseVersion + "] is not a valid Semantic Versioning");
        }
        this.versionMajor = Integer.parseInt((String)versionSplit.get(0));
        this.versionMinor = Integer.parseInt((String)versionSplit.get(1));
        this.versionPatch = Integer.parseInt((String)versionSplit.get(2));
        this.validateBaseVersion();
    }

    private final void validateBaseVersion() {
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                Integer n = this.versionMajor;
                                Intrinsics.checkNotNull((Object)n);
                                int n2 = n;
                                Integer n3 = this.maximumVersion;
                                Intrinsics.checkNotNull((Object)n3);
                                if (n2 > n3) break block6;
                                Integer n4 = this.versionMajor;
                                Intrinsics.checkNotNull((Object)n4);
                                if (n4 >= 0) break block7;
                            }
                            throw new RuntimeException("The version major [" + this.versionMajor + "] should be a number between 0 and " + this.maximumVersion);
                        }
                        Integer n = this.versionMinor;
                        Intrinsics.checkNotNull((Object)n);
                        int n5 = n;
                        Integer n6 = this.maximumVersion;
                        Intrinsics.checkNotNull((Object)n6);
                        if (n5 > n6) break block8;
                        Integer n7 = this.versionMinor;
                        Intrinsics.checkNotNull((Object)n7);
                        if (n7 >= 0) break block9;
                    }
                    throw new RuntimeException("The version minor [" + this.versionMinor + "] should be a number between 0 and " + this.maximumVersion);
                }
                Integer n = this.versionPatch;
                Intrinsics.checkNotNull((Object)n);
                int n8 = n;
                Integer n9 = this.maximumVersion;
                Intrinsics.checkNotNull((Object)n9);
                if (n8 > n9) break block10;
                Integer n10 = this.versionPatch;
                Intrinsics.checkNotNull((Object)n10);
                if (n10 >= 0) break block11;
            }
            throw new RuntimeException("The version patch [" + this.versionPatch + "] should be a number between 0 and " + this.maximumVersion);
        }
    }

    public final void incrementMajor() {
        Integer n = this.versionMajor;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = this.maximumVersion;
        Intrinsics.checkNotNull((Object)n3);
        if (n2 >= n3) {
            throw new RuntimeException("The version major [" + this.versionMajor + "] can't be incremented. Maximum value achieved.");
        }
        Integer n4 = this.versionMajor;
        Intrinsics.checkNotNull((Object)n4);
        this.versionMajor = n4 + 1;
        this.versionMinor = 0;
        this.versionPatch = 0;
    }

    public final void incrementMinor() {
        Integer n = this.versionMinor;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = this.maximumVersion;
        Intrinsics.checkNotNull((Object)n3);
        if (n2 < n3) {
            Integer n4 = this.versionMinor;
            Intrinsics.checkNotNull((Object)n4);
            this.versionMinor = n4 + 1;
            this.versionPatch = 0;
        } else {
            this.incrementMajor();
        }
    }

    public final void incrementPatch() {
        Integer n = this.versionPatch;
        Intrinsics.checkNotNull((Object)n);
        int n2 = n;
        Integer n3 = this.maximumVersion;
        Intrinsics.checkNotNull((Object)n3);
        if (n2 < n3) {
            Integer n4 = this.versionPatch;
            Intrinsics.checkNotNull((Object)n4);
            this.versionPatch = n4 + 1;
        } else {
            this.incrementMinor();
        }
    }

    @NotNull
    public String toString() {
        String versionName = this.getBaseVersion();
        CharSequence charSequence = this.versionClassifier;
        if (!(charSequence == null || charSequence.length() == 0)) {
            versionName = versionName + '-' + this.versionClassifier;
        }
        return versionName;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/semanticversion/Version$Companion;", "", "()V", "ALPHA_CLASSIFIER", "", "BASE_VERSION_SEPARATOR", "BETA_CLASSIFIER", "SNAPSHOT_CLASSIFIER", "VERSION_CLASSIFIER_SEPARATOR", "semantic-version"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

