/*
 * Decompiled with CFR 0.152.
 */
package com.semanticversion.android;

import com.semanticversion.Version;
import com.semanticversion.android.AndroidSemanticVersionConfig;
import com.semanticversion.utils.IntExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/semanticversion/android/AndroidVersion;", "Lcom/semanticversion/Version;", "baseVersion", "", "config", "Lcom/semanticversion/android/AndroidSemanticVersionConfig;", "(Ljava/lang/String;Lcom/semanticversion/android/AndroidSemanticVersionConfig;)V", "versionCode", "", "(I)V", "getVersionCode", "()I", "versionCodeExtraBit", "getVersionCodeExtraBit", "()Ljava/lang/Integer;", "setVersionCodeExtraBit", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "versionCodePrefix", "getVersionCodePrefix", "setVersionCodePrefix", "Companion", "semantic-version"})
public final class AndroidVersion
extends Version {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private Integer versionCodePrefix;
    @Nullable
    private Integer versionCodeExtraBit;
    private final int versionCode;

    @Nullable
    public final Integer getVersionCodePrefix() {
        return this.versionCodePrefix;
    }

    public final void setVersionCodePrefix(@Nullable Integer n) {
        this.versionCodePrefix = n;
    }

    @Nullable
    public final Integer getVersionCodeExtraBit() {
        return this.versionCodeExtraBit;
    }

    public final void setVersionCodeExtraBit(@Nullable Integer n) {
        this.versionCodeExtraBit = n;
    }

    public final int getVersionCode() {
        return this.versionCode;
    }

    public AndroidVersion(@NotNull String baseVersion, @NotNull AndroidSemanticVersionConfig config) {
        Intrinsics.checkNotNullParameter((Object)baseVersion, (String)"baseVersion");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(baseVersion, config);
        this.versionCodePrefix = config.getVersionCodePrefix() == null ? (config.getMinSdkVersionAsVersionCodePrefix() ? Integer.valueOf(config.getMinSdkVersion()) : Integer.valueOf(0)) : config.getVersionCodePrefix();
        this.versionCodeExtraBit = config.getVersionCodeExtraBit();
        Integer n = this.getMaximumVersion();
        Intrinsics.checkNotNull((Object)n);
        int versionMultiplier = (int)Math.pow(10.0, IntExtensionKt.countDigits(n));
        Integer n2 = this.versionCodeExtraBit;
        Intrinsics.checkNotNull((Object)n2);
        int versionCodeExtraBitMultiplier = (int)Math.pow(10.0, IntExtensionKt.countDigits(n2));
        Integer n3 = this.versionCodePrefix;
        Intrinsics.checkNotNull((Object)n3);
        int n4 = n3 * versionCodeExtraBitMultiplier * versionMultiplier * versionMultiplier * versionMultiplier;
        Integer n5 = this.versionCodeExtraBit;
        Intrinsics.checkNotNull((Object)n5);
        int n6 = n4 + n5 * versionMultiplier * versionMultiplier * versionMultiplier;
        Integer n7 = this.getVersionMajor();
        Intrinsics.checkNotNull((Object)n7);
        int n8 = n6 + n7 * versionMultiplier * versionMultiplier;
        Integer n9 = this.getVersionMinor();
        Intrinsics.checkNotNull((Object)n9);
        int n10 = n8 + n9 * versionMultiplier;
        Integer n11 = this.getVersionPatch();
        Intrinsics.checkNotNull((Object)n11);
        this.versionCode = n10 + n11;
    }

    public AndroidVersion(int versionCode) {
        super(Companion.fromVersionCodeToVersionName(versionCode), null, 2, null);
        this.versionCode = versionCode;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/semanticversion/android/AndroidVersion$Companion;", "", "()V", "fromVersionCodeToVersionName", "", "versionCode", "", "semantic-version"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String fromVersionCodeToVersionName(int versionCode) {
            String versionCodeString = String.valueOf(versionCode);
            int beginIndex = versionCodeString.length() - 2;
            int endIndex = versionCodeString.length();
            String string = versionCodeString.substring(Math.max(beginIndex, 0), Math.max(endIndex, 0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Integer n = StringsKt.toIntOrNull((String)string);
            int patch = n != null ? n : 0;
            String string2 = versionCodeString.substring(Math.max(beginIndex -= 2, 0), Math.max(endIndex -= 2, 0));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Integer n2 = StringsKt.toIntOrNull((String)string2);
            int minor = n2 != null ? n2 : 0;
            String string3 = versionCodeString.substring(Math.max(beginIndex -= 2, 0), Math.max(endIndex -= 2, 0));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Integer n3 = StringsKt.toIntOrNull((String)string3);
            int major = n3 != null ? n3 : 0;
            return "" + major + '.' + minor + '.' + patch;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

