/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.regex.Pattern;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;

public class MAILFWRecord
extends Record {
    private static final long serialVersionUID = -368229832408733122L;
    private static final Pattern MAIL_DESTINATION_PATTERN = Pattern.compile("^([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*)?@([a-zA-Z0-9_]([a-zA-Z0-9-_]{0,61}[a-zA-Z0-9_])?\\.)+[a-zA-Z0-9_][a-zA-Z0-9-_]{0,4}[a-zA-Z0-9_]$", 2);
    private static final Pattern MAIL_ORIGINAL_RECIPIENT_PATTERN = Pattern.compile("^([_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*)?$", 2);
    private String originalRecipient;
    private String destination;

    MAILFWRecord() {
    }

    @Override
    Record getObject() {
        return new MAILFWRecord();
    }

    public MAILFWRecord(Name name, int dclass, long ttl, String destination) {
        super(name, 65283, dclass, ttl);
        this.setDestination(destination);
    }

    public MAILFWRecord(Name name, int dclass, long ttl, String originalRecipient, String destination) {
        this(name, dclass, ttl, destination);
        this.setOriginalRecipient(originalRecipient);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        String firstValue = new String(in.readCountedString());
        try {
            String secondValue = new String(in.readCountedString());
            this.setOriginalRecipient(firstValue);
            this.setDestination(secondValue);
        }
        catch (WireParseException e) {
            this.setDestination(firstValue);
        }
    }

    @Override
    String rrToString() {
        return (this.originalRecipient != null ? this.originalRecipient + " " : "") + this.destination;
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String firstValue = st.getString();
        try {
            String secondValue = st.getString();
            this.setOriginalRecipient(firstValue);
            this.setDestination(secondValue);
        }
        catch (IOException e) {
            this.setDestination(firstValue);
        }
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        if (this.originalRecipient != null) {
            try {
                out.writeCountedString(MAILFWRecord.byteArrayFromString(this.originalRecipient));
            }
            catch (TextParseException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if (this.destination != null) {
            try {
                out.writeCountedString(MAILFWRecord.byteArrayFromString(this.destination));
            }
            catch (TextParseException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public String getDestination() {
        return this.destination;
    }

    private void setDestination(String destination) {
        this.destination = destination;
    }

    private void setOriginalRecipient(String originalRecipient) {
        this.originalRecipient = originalRecipient;
    }

    public String getOriginalRecipient() {
        return this.originalRecipient;
    }
}

