/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.WireParseException;

public class Name
implements Comparable,
Serializable {
    private static final long serialVersionUID = -7257019940971525644L;
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_MASK = 192;
    private byte[] name;
    private long offsets;
    private int hashcode;
    private static final byte[] emptyLabel = new byte[]{0};
    private static final byte[] wildLabel = new byte[]{1, 42};
    public static final Name root;
    public static final Name empty;
    private static final int MAXNAME = 255;
    private static final int MAXLABEL = 63;
    private static final int MAXLABELS = 128;
    private static final int MAXOFFSETS = 7;
    private static final DecimalFormat byteFormat;
    private static final byte[] lowercase;
    private static final Name wild;

    private Name() {
    }

    private final void setoffset(int n, int offset) {
        if (n >= 7) {
            return;
        }
        int shift = 8 * (7 - n);
        this.offsets &= 255L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.offsets |= (long)offset << shift;
    }

    private final int offset(int n) {
        if (n == 0 && this.getlabels() == 0) {
            return 0;
        }
        if (n < 0 || n >= this.getlabels()) {
            throw new IllegalArgumentException("label out of range");
        }
        if (n < 7) {
            int shift = 8 * (7 - n);
            return (int)(this.offsets >>> shift) & 0xFF;
        }
        int pos = this.offset(6);
        for (int i = 6; i < n; ++i) {
            pos += this.name[pos] + 1;
        }
        return pos;
    }

    private final void setlabels(int labels) {
        this.offsets &= 0xFFFFFFFFFFFFFF00L;
        this.offsets |= (long)labels;
    }

    private final int getlabels() {
        return (int)(this.offsets & 0xFFL);
    }

    private static final void copy(Name src, Name dst) {
        if (src.offset(0) == 0) {
            dst.name = src.name;
            dst.offsets = src.offsets;
        } else {
            int offset0 = src.offset(0);
            int namelen = src.name.length - offset0;
            int labels = src.labels();
            dst.name = new byte[namelen];
            System.arraycopy(src.name, offset0, dst.name, 0, namelen);
            for (int i = 0; i < labels && i < 7; ++i) {
                dst.setoffset(i, src.offset(i) - offset0);
            }
            dst.setlabels(labels);
        }
    }

    private final void append(byte[] array, int start, int n) throws NameTooLongException {
        int length = this.name == null ? 0 : this.name.length - this.offset(0);
        int alength = 0;
        int pos = start;
        for (int i = 0; i < n; ++i) {
            int len = array[pos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            pos += ++len;
            alength += len;
        }
        int newlength = length + alength;
        if (newlength > 255) {
            throw new NameTooLongException();
        }
        int labels = this.getlabels();
        int newlabels = labels + n;
        if (newlabels > 128) {
            throw new IllegalStateException("too many labels");
        }
        byte[] newname = new byte[newlength];
        if (length != 0) {
            System.arraycopy(this.name, this.offset(0), newname, 0, length);
        }
        System.arraycopy(array, start, newname, length, alength);
        this.name = newname;
        int pos2 = length;
        for (int i = 0; i < n; ++i) {
            this.setoffset(labels + i, pos2);
            pos2 += newname[pos2] + 1;
        }
        this.setlabels(newlabels);
    }

    private static TextParseException parseException(String str, String message) {
        return new TextParseException("'" + str + "': " + message);
    }

    private final void appendFromString(String fullName, byte[] array, int start, int n) throws TextParseException {
        try {
            this.append(array, start, n);
        }
        catch (NameTooLongException e) {
            throw Name.parseException(fullName, "Name too long");
        }
    }

    private final void appendSafe(byte[] array, int start, int n) {
        try {
            this.append(array, start, n);
        }
        catch (NameTooLongException e) {
            // empty catch block
        }
    }

    public Name(String s, Name origin) throws TextParseException {
        if (s.equals("")) {
            throw Name.parseException(s, "empty name");
        }
        if (s.equals("@")) {
            if (origin == null) {
                Name.copy(empty, this);
            } else {
                Name.copy(origin, this);
            }
            return;
        }
        if (s.equals(".")) {
            Name.copy(root, this);
            return;
        }
        int labelstart = -1;
        int pos = 1;
        byte[] label = new byte[64];
        boolean escaped = false;
        int digits = 0;
        int intval = 0;
        boolean absolute = false;
        for (int i = 0; i < s.length(); ++i) {
            byte b = (byte)s.charAt(i);
            if (escaped) {
                if (b >= 48 && b <= 57 && digits < 3) {
                    ++digits;
                    intval *= 10;
                    if ((intval += b - 48) > 255) {
                        throw Name.parseException(s, "bad escape");
                    }
                    if (digits < 3) continue;
                    b = (byte)intval;
                } else if (digits > 0 && digits < 3) {
                    throw Name.parseException(s, "bad escape");
                }
                if (pos > 63) {
                    throw Name.parseException(s, "label too long");
                }
                labelstart = pos;
                label[pos++] = b;
                escaped = false;
                continue;
            }
            if (b == 92) {
                escaped = true;
                digits = 0;
                intval = 0;
                continue;
            }
            if (b == 46) {
                if (labelstart == -1) {
                    throw Name.parseException(s, "invalid empty label");
                }
                label[0] = (byte)(pos - 1);
                this.appendFromString(s, label, 0, 1);
                labelstart = -1;
                pos = 1;
                continue;
            }
            if (labelstart == -1) {
                labelstart = i;
            }
            if (pos > 63) {
                throw Name.parseException(s, "label too long");
            }
            label[pos++] = b;
        }
        if (digits > 0 && digits < 3) {
            throw Name.parseException(s, "bad escape");
        }
        if (escaped) {
            throw Name.parseException(s, "bad escape");
        }
        if (labelstart == -1) {
            this.appendFromString(s, emptyLabel, 0, 1);
            absolute = true;
        } else {
            label[0] = (byte)(pos - 1);
            this.appendFromString(s, label, 0, 1);
        }
        if (origin != null && !absolute) {
            this.appendFromString(s, origin.name, 0, origin.getlabels());
        }
    }

    public Name(String s) throws TextParseException {
        this(s, null);
    }

    public static Name fromString(String s, Name origin) throws TextParseException {
        if (s.equals("@") && origin != null) {
            return origin;
        }
        if (s.equals(".")) {
            return root;
        }
        return new Name(s, origin);
    }

    public static Name fromString(String s) throws TextParseException {
        return Name.fromString(s, null);
    }

    public static Name fromConstantString(String s) {
        try {
            return Name.fromString(s, null);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid name '" + s + "'");
        }
    }

    public Name(DNSInput in) throws WireParseException {
        boolean done = false;
        byte[] label = new byte[64];
        boolean savedState = false;
        block4: while (!done) {
            int len = in.readU8();
            switch (len & 0xC0) {
                case 0: {
                    if (this.getlabels() >= 128) {
                        throw new WireParseException("too many labels");
                    }
                    if (len == 0) {
                        this.append(emptyLabel, 0, 1);
                        done = true;
                        continue block4;
                    }
                    label[0] = (byte)len;
                    in.readByteArray(label, 1, len);
                    this.append(label, 0, 1);
                    continue block4;
                }
                case 192: {
                    int pos = in.readU8();
                    pos += (len & 0xFFFFFF3F) << 8;
                    if (Options.check("verbosecompression")) {
                        System.err.println("currently " + in.current() + ", pointer to " + pos);
                    }
                    if (pos >= in.current() - 2) {
                        throw new WireParseException("bad compression");
                    }
                    if (!savedState) {
                        in.save();
                        savedState = true;
                    }
                    in.jump(pos);
                    if (!Options.check("verbosecompression")) continue block4;
                    System.err.println("current name '" + this + "', seeking to " + pos);
                    continue block4;
                }
            }
            throw new WireParseException("bad label type");
        }
        if (savedState) {
            in.restore();
        }
    }

    public Name(byte[] b) throws IOException {
        this(new DNSInput(b));
    }

    public Name(Name src, int n) {
        int slabels = src.labels();
        if (n > slabels) {
            throw new IllegalArgumentException("attempted to remove too many labels");
        }
        this.name = src.name;
        this.setlabels(slabels - n);
        for (int i = 0; i < 7 && i < slabels - n; ++i) {
            this.setoffset(i, src.offset(i + n));
        }
    }

    public static Name concatenate(Name prefix, Name suffix) throws NameTooLongException {
        if (prefix.isAbsolute()) {
            return prefix;
        }
        Name newname = new Name();
        Name.copy(prefix, newname);
        newname.append(suffix.name, suffix.offset(0), suffix.getlabels());
        return newname;
    }

    public Name relativize(Name origin) {
        if (origin == null || !this.subdomain(origin)) {
            return this;
        }
        Name newname = new Name();
        Name.copy(this, newname);
        int length = this.length() - origin.length();
        int labels = newname.labels() - origin.labels();
        newname.setlabels(labels);
        newname.name = new byte[length];
        System.arraycopy(this.name, this.offset(0), newname.name, 0, length);
        return newname;
    }

    public Name wild(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("must replace 1 or more labels");
        }
        try {
            Name newname = new Name();
            Name.copy(wild, newname);
            newname.append(this.name, this.offset(n), this.getlabels() - n);
            return newname;
        }
        catch (NameTooLongException e) {
            throw new IllegalStateException("Name.wild: concatenate failed");
        }
    }

    public Name canonicalize() {
        boolean canonical = true;
        for (int i = 0; i < this.name.length; ++i) {
            if (lowercase[this.name[i] & 0xFF] == this.name[i]) continue;
            canonical = false;
            break;
        }
        if (canonical) {
            return this;
        }
        Name newname = new Name();
        newname.appendSafe(this.name, this.offset(0), this.getlabels());
        for (int i = 0; i < newname.name.length; ++i) {
            newname.name[i] = lowercase[newname.name[i] & 0xFF];
        }
        return newname;
    }

    public Name fromDNAME(DNAMERecord dname) throws NameTooLongException {
        Name dnameowner = dname.getName();
        Name dnametarget = dname.getTarget();
        if (!this.subdomain(dnameowner)) {
            return null;
        }
        int plabels = this.labels() - dnameowner.labels();
        int plength = this.length() - dnameowner.length();
        int pstart = this.offset(0);
        int dlabels = dnametarget.labels();
        short dlength = dnametarget.length();
        if (plength + dlength > 255) {
            throw new NameTooLongException();
        }
        Name newname = new Name();
        newname.setlabels(plabels + dlabels);
        newname.name = new byte[plength + dlength];
        System.arraycopy(this.name, pstart, newname.name, 0, plength);
        System.arraycopy(dnametarget.name, 0, newname.name, plength, dlength);
        int pos = 0;
        for (int i = 0; i < 7 && i < plabels + dlabels; ++i) {
            newname.setoffset(i, pos);
            pos += newname.name[pos] + 1;
        }
        return newname;
    }

    public boolean isWild() {
        if (this.labels() == 0) {
            return false;
        }
        return this.name[0] == 1 && this.name[1] == 42;
    }

    public boolean isAbsolute() {
        int nlabels = this.labels();
        if (nlabels == 0) {
            return false;
        }
        return this.name[this.offset(nlabels - 1)] == 0;
    }

    public short length() {
        if (this.getlabels() == 0) {
            return 0;
        }
        return (short)(this.name.length - this.offset(0));
    }

    public int labels() {
        return this.getlabels();
    }

    public boolean subdomain(Name domain) {
        int labels = this.labels();
        int dlabels = domain.labels();
        if (dlabels > labels) {
            return false;
        }
        if (dlabels == labels) {
            return this.equals(domain);
        }
        return domain.equals(this.name, this.offset(labels - dlabels));
    }

    private String byteString(byte[] array, int pos) {
        StringBuffer sb = new StringBuffer();
        byte len = array[pos++];
        for (int i = pos; i < pos + len; ++i) {
            int b = array[i] & 0xFF;
            if (b <= 32 || b >= 127) {
                sb.append('\\');
                sb.append(byteFormat.format(b));
                continue;
            }
            if (b == 34 || b == 40 || b == 41 || b == 46 || b == 59 || b == 92 || b == 64 || b == 36) {
                sb.append('\\');
                sb.append((char)b);
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    public String toString(boolean omitFinalDot) {
        int labels = this.labels();
        if (labels == 0) {
            return "@";
        }
        if (labels == 1 && this.name[this.offset(0)] == 0) {
            return ".";
        }
        StringBuffer sb = new StringBuffer();
        int pos = this.offset(0);
        for (int i = 0; i < labels; ++i) {
            byte len = this.name[pos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            if (len == 0) {
                if (omitFinalDot) break;
                sb.append('.');
                break;
            }
            if (i > 0) {
                sb.append('.');
            }
            sb.append(this.byteString(this.name, pos));
            pos += 1 + len;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] getLabel(int n) {
        int pos = this.offset(n);
        byte len = (byte)(this.name[pos] + 1);
        byte[] label = new byte[len];
        System.arraycopy(this.name, pos, label, 0, len);
        return label;
    }

    public String getLabelString(int n) {
        int pos = this.offset(n);
        return this.byteString(this.name, pos);
    }

    public void toWire(DNSOutput out, Compression c) {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("toWire() called on non-absolute name");
        }
        int labels = this.labels();
        for (int i = 0; i < labels - 1; ++i) {
            Name tname = i == 0 ? this : new Name(this, i);
            int pos = -1;
            if (c != null) {
                pos = c.get(tname);
            }
            if (pos >= 0) {
                out.writeU16(pos |= 0xC000);
                return;
            }
            if (c != null) {
                c.add(out.current(), tname);
            }
            int off = this.offset(i);
            out.writeByteArray(this.name, off, this.name[off] + 1);
        }
        out.writeU8(0);
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out, null);
        return out.toByteArray();
    }

    public void toWireCanonical(DNSOutput out) {
        byte[] b = this.toWireCanonical();
        out.writeByteArray(b);
    }

    public byte[] toWireCanonical() {
        int labels = this.labels();
        if (labels == 0) {
            return new byte[0];
        }
        byte[] b = new byte[this.name.length - this.offset(0)];
        int spos = this.offset(0);
        int dpos = 0;
        for (int i = 0; i < labels; ++i) {
            int len = this.name[spos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            b[dpos++] = this.name[spos++];
            for (int j = 0; j < len; ++j) {
                b[dpos++] = lowercase[this.name[spos++] & 0xFF];
            }
        }
        return b;
    }

    public void toWire(DNSOutput out, Compression c, boolean canonical) {
        if (canonical) {
            this.toWireCanonical(out);
        } else {
            this.toWire(out, c);
        }
    }

    private final boolean equals(byte[] b, int bpos) {
        int labels = this.labels();
        int pos = this.offset(0);
        for (int i = 0; i < labels; ++i) {
            if (this.name[pos] != b[bpos]) {
                return false;
            }
            int len = this.name[pos++];
            ++bpos;
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            for (int j = 0; j < len; ++j) {
                if (lowercase[this.name[pos++] & 0xFF] == lowercase[b[bpos++] & 0xFF]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof Name)) {
            return false;
        }
        Name d = (Name)arg;
        if (d.hashcode == 0) {
            d.hashCode();
        }
        if (this.hashcode == 0) {
            this.hashCode();
        }
        if (d.hashcode != this.hashcode) {
            return false;
        }
        if (d.labels() != this.labels()) {
            return false;
        }
        return this.equals(d.name, d.offset(0));
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int code = 0;
        for (int i = this.offset(0); i < this.name.length; ++i) {
            code += (code << 3) + lowercase[this.name[i] & 0xFF];
        }
        this.hashcode = code;
        return this.hashcode;
    }

    public int compareTo(Object o) {
        int alabels;
        Name arg = (Name)o;
        if (this == arg) {
            return 0;
        }
        int labels = this.labels();
        int compares = labels > (alabels = arg.labels()) ? alabels : labels;
        for (int i = 1; i <= compares; ++i) {
            int start = this.offset(labels - i);
            int astart = arg.offset(alabels - i);
            int length = this.name[start];
            byte alength = arg.name[astart];
            for (int j = 0; j < length && j < alength; ++j) {
                int n = lowercase[this.name[j + start + 1] & 0xFF] - lowercase[arg.name[j + astart + 1] & 0xFF];
                if (n == 0) continue;
                return n;
            }
            if (length == alength) continue;
            return length - alength;
        }
        return labels - alabels;
    }

    static {
        byteFormat = new DecimalFormat();
        lowercase = new byte[256];
        byteFormat.setMinimumIntegerDigits(3);
        for (int i = 0; i < lowercase.length; ++i) {
            Name.lowercase[i] = i < 65 || i > 90 ? (byte)i : (byte)(i - 65 + 97);
        }
        root = new Name();
        root.appendSafe(emptyLabel, 0, 1);
        empty = new Name();
        Name.empty.name = new byte[0];
        wild = new Name();
        wild.appendSafe(wildLabel, 0, 1);
    }
}

