/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.security.SecureRandom;
import org.xbill.DNS.Client;

final class UDPClient
extends Client {
    private static final int EPHEMERAL_START = 1024;
    private static final int EPHEMERAL_STOP = 65535;
    private static final int EPHEMERAL_RANGE = 64511;
    private static SecureRandom prng = new SecureRandom();
    private static volatile boolean prng_initializing = true;
    private boolean bound = false;

    public UDPClient(long endTime) throws IOException {
        super(DatagramChannel.open(), endTime);
    }

    private void bind_random(InetSocketAddress addr) throws IOException {
        if (prng_initializing) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (prng_initializing) {
                return;
            }
        }
        DatagramChannel channel = (DatagramChannel)this.key.channel();
        for (int i = 0; i < 1024; ++i) {
            try {
                int port = prng.nextInt(64511) + 1024;
                InetSocketAddress temp = addr != null ? new InetSocketAddress(addr.getAddress(), port) : new InetSocketAddress(port);
                channel.socket().bind(temp);
                this.bound = true;
                return;
            }
            catch (SocketException e) {
                continue;
            }
        }
    }

    void bind(SocketAddress addr) throws IOException {
        if (addr == null || addr instanceof InetSocketAddress && ((InetSocketAddress)addr).getPort() == 0) {
            this.bind_random((InetSocketAddress)addr);
            if (this.bound) {
                return;
            }
        }
        if (addr != null) {
            DatagramChannel channel = (DatagramChannel)this.key.channel();
            channel.socket().bind(addr);
            this.bound = true;
        }
    }

    void connect(SocketAddress addr) throws IOException {
        if (!this.bound) {
            this.bind(null);
        }
        DatagramChannel channel = (DatagramChannel)this.key.channel();
        channel.connect(addr);
    }

    void send(byte[] data) throws IOException {
        DatagramChannel channel = (DatagramChannel)this.key.channel();
        UDPClient.verboseLog("UDP write", data);
        channel.write(ByteBuffer.wrap(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] recv(int max) throws IOException {
        DatagramChannel channel = (DatagramChannel)this.key.channel();
        byte[] temp = new byte[max];
        this.key.interestOps(1);
        try {
            while (!this.key.isReadable()) {
                UDPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
        long ret = channel.read(ByteBuffer.wrap(temp));
        if (ret <= 0L) {
            throw new EOFException();
        }
        int len = (int)ret;
        byte[] data = new byte[len];
        System.arraycopy(temp, 0, data, 0, len);
        UDPClient.verboseLog("UDP read", data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sendrecv(SocketAddress local, SocketAddress remote, byte[] data, int max, long endTime) throws IOException {
        UDPClient client = new UDPClient(endTime);
        try {
            client.bind(local);
            client.connect(remote);
            client.send(data);
            byte[] byArray = client.recv(max);
            return byArray;
        }
        finally {
            client.cleanup();
        }
    }

    static byte[] sendrecv(SocketAddress addr, byte[] data, int max, long endTime) throws IOException {
        return UDPClient.sendrecv(null, addr, data, max, endTime);
    }

    static {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int n = prng.nextInt();
                prng_initializing = false;
            }
        }).start();
    }
}

