/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.regex.Pattern;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;

public class URLRecord
extends Record {
    private static final long serialVersionUID = -5287280745661128913L;
    private static final Pattern URL_TEMPLATE_PATTERN = Pattern.compile("^(https?)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;{}]*[-a-zA-Z0-9+&@#/%=~_|}]$", 2);
    private static final Pattern URL_CLOAKING_PARAMETERS_PATTERN = Pattern.compile("^[^<>]*$", 2);
    private String keywords;
    private String description;
    private String title;
    private String template;
    private int redirectType;

    URLRecord() {
    }

    public URLRecord(Name name, int dclass, long ttl, String template) {
        this(name, dclass, ttl, template, 0);
    }

    public URLRecord(Name name, int dclass, long ttl, String template, int redirectType) {
        super(name, 65282, dclass, ttl);
        this.setTemplate(template);
        this.redirectType = URLRecord.checkU8("redirectType", redirectType);
    }

    public URLRecord(Name name, int dclass, long ttl, String template, int redirectType, String title, String description, String keywords) {
        this(name, dclass, ttl, template, redirectType);
        if (redirectType == 4) {
            this.setTitle(title);
            this.setDescription(description);
            this.setKeywords(keywords);
        }
    }

    @Override
    Record getObject() {
        return new URLRecord();
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.setTemplate(new String(in.readCountedString()));
        try {
            this.redirectType = in.readU8();
        }
        catch (WireParseException e) {
            this.redirectType = 0;
        }
        if (this.redirectType == 4) {
            try {
                this.setTitle(new String(in.readCountedString()));
            }
            catch (IOException e) {
                this.setTitle(null);
            }
            try {
                this.setDescription(new String(in.readCountedString()));
            }
            catch (IOException e) {
                this.setDescription(null);
            }
            try {
                this.setKeywords(new String(in.readCountedString()));
            }
            catch (IOException e) {
                this.setKeywords(null);
            }
        }
    }

    @Override
    String rrToString() {
        String recordDetails = this.template + " " + this.redirectType;
        if (this.redirectType == 4) {
            recordDetails = recordDetails + " \"" + (this.title != null ? this.title : "") + "\" \"" + (this.description != null ? this.description : "") + "\" \"" + (this.keywords != null ? this.keywords : "") + "\"";
        }
        return recordDetails.trim();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        String redirectTypeString;
        this.setTemplate(st.getString());
        try {
            redirectTypeString = st.getString();
        }
        catch (IOException e) {
            this.redirectType = 0;
            return;
        }
        this.redirectType = RedirectType.value(redirectTypeString);
        if (this.redirectType < 0) {
            throw st.exception("Invalid redirect type: " + redirectTypeString);
        }
        if (this.redirectType == 4) {
            try {
                this.setTitle(st.getString());
            }
            catch (IOException e) {
                this.setTitle(null);
            }
            try {
                this.setDescription(st.getString());
            }
            catch (IOException e) {
                this.setDescription(null);
            }
            try {
                this.setKeywords(st.getString());
            }
            catch (IOException e) {
                this.setKeywords(null);
            }
        }
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        if (this.template != null) {
            try {
                out.writeCountedString(URLRecord.byteArrayFromString(this.template));
            }
            catch (TextParseException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        out.writeU8(this.redirectType);
        if (this.redirectType == 4) {
            if (this.title != null) {
                try {
                    out.writeCountedString(URLRecord.byteArrayFromString(this.title));
                }
                catch (TextParseException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            if (this.description != null) {
                try {
                    out.writeCountedString(URLRecord.byteArrayFromString(this.description));
                }
                catch (TextParseException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            if (this.keywords != null) {
                try {
                    out.writeCountedString(URLRecord.byteArrayFromString(this.keywords));
                }
                catch (TextParseException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        }
    }

    public int getRedirectType() {
        return this.redirectType;
    }

    private void setTemplate(String template) {
        if (!URL_TEMPLATE_PATTERN.matcher(template).matches()) {
            throw new IllegalArgumentException("Provided template '" + template + "' is not a valid URI template");
        }
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null && !URL_CLOAKING_PARAMETERS_PATTERN.matcher(title).matches()) {
            throw new IllegalArgumentException("Provided title '" + title + "' is not a valid HTML title");
        }
        this.title = title;
    }

    public void setKeywords(String keywords) {
        if (keywords != null && !URL_CLOAKING_PARAMETERS_PATTERN.matcher(keywords).matches()) {
            throw new IllegalArgumentException("Provided keywords '" + keywords + "' are not valid HTML keywords");
        }
        this.keywords = keywords;
    }

    public void setDescription(String description) {
        if (description != null && !URL_CLOAKING_PARAMETERS_PATTERN.matcher(description).matches()) {
            throw new IllegalArgumentException("Provided description '" + description + "' is not a valid HTML description");
        }
        this.description = description;
    }

    public static final class RedirectType {
        public static final int REDIRECT_TYPE_302 = 0;
        public static final int REDIRECT_TYPE_301 = 1;
        public static final int REDIRECT_TYPE_303 = 2;
        public static final int REDIRECT_TYPE_307 = 3;
        public static final int REDIRECT_TYPE_CLOAKING_IFRAME = 4;
        private static Mnemonic redirectTypes = new Mnemonic("URL Redirection Types", 2);

        private RedirectType() {
        }

        public static String string(int alg) {
            return redirectTypes.getText(alg);
        }

        public static int value(String s) {
            return redirectTypes.getValue(s);
        }

        static {
            redirectTypes.setMaximum(4);
            redirectTypes.setNumericAllowed(true);
            redirectTypes.add(0, "302");
            redirectTypes.add(1, "301");
            redirectTypes.add(2, "303");
            redirectTypes.add(3, "307");
            redirectTypes.add(4, "Cloaking");
        }
    }
}

