/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.exception.MissingFieldJsonDeserializationException;

public abstract class AbstractDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 5081830517002430714L;

    protected AbstractDeserializer(Class<?> vc) {
        super(vc);
    }

    protected JsonNode findFieldNode(ObjectNode recordNode, String fieldName) {
        JsonNode fieldNode = recordNode.get(fieldName);
        if (fieldNode == null) {
            throw new MissingFieldJsonDeserializationException(fieldName, this.getTextualBeanType());
        }
        return fieldNode;
    }

    protected String getNodeStringValue(ObjectNode recordNode, String fieldName) {
        return this.findFieldNode(recordNode, fieldName).textValue();
    }

    public Name getNameFromString(String nodeValue) throws TextParseException {
        return Name.fromString(nodeValue, Name.root);
    }

    protected Name getNodeNameValue(ObjectNode recordNode, String fieldName) {
        try {
            return this.getNameFromString(this.getNodeStringValue(recordNode, fieldName));
        }
        catch (TextParseException e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, (Throwable)e, fieldName, this.getTextualBeanType(), e.getMessage());
        }
    }

    protected Number getNodeNumberValue(ObjectNode recordNode, String fieldName) {
        JsonNode fieldNode = this.findFieldNode(recordNode, fieldName);
        switch (fieldNode.getNodeType()) {
            case NUMBER: {
                return fieldNode.numberValue();
            }
            case STRING: {
                try {
                    return NumberFormat.getInstance(Locale.getDefault()).parse(fieldNode.textValue());
                }
                catch (ParseException e) {
                    throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, (Throwable)e, fieldName, this.getTextualBeanType(), e.getMessage());
                }
            }
        }
        throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, fieldName, this.getTextualBeanType(), "Field cannot be read as a number");
    }

    protected Long getNodeLongValue(ObjectNode recordNode, String fieldName) {
        return this.getNodeNumberValue(recordNode, fieldName).longValue();
    }

    public Integer getNodeIntegerValue(ObjectNode recordNode, String fieldName) {
        return this.getNodeNumberValue(recordNode, fieldName).intValue();
    }

    protected Double getNodeDoubleValue(ObjectNode recordNode, String fieldName) {
        return this.getNodeNumberValue(recordNode, fieldName).doubleValue();
    }

    protected Boolean getNodeBooleanValue(ObjectNode recordNode, String fieldName) {
        JsonNode fieldNode = this.findFieldNode(recordNode, fieldName);
        switch (fieldNode.getNodeType()) {
            case BOOLEAN: {
                return fieldNode.booleanValue();
            }
            case STRING: {
                return Boolean.valueOf(fieldNode.textValue());
            }
        }
        throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, fieldName, this.getTextualBeanType(), "Field cannot be read as a boolean");
    }

    public InetAddress getNodeAddressValue(ObjectNode recordNode, String fieldName) {
        JsonNode addressNode = this.findFieldNode(recordNode, fieldName);
        try {
            if (addressNode.textValue() != null) {
                return this.getAddressFromString(addressNode.textValue());
            }
            return null;
        }
        catch (Throwable e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, e, fieldName, this.getTextualBeanType(), e.getMessage());
        }
    }

    public URL getNodeURLValue(ObjectNode recordNode, String fieldName) {
        JsonNode addressNode = this.findFieldNode(recordNode, fieldName);
        try {
            if (addressNode.textValue() != null) {
                return this.getURLFromString(addressNode.textValue());
            }
            return null;
        }
        catch (Throwable e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, e, fieldName, this.getTextualBeanType(), e.getMessage());
        }
    }

    public Date getNodeDateValue(ObjectNode recordNode, String fieldName) {
        try {
            return new Date(this.getNodeLongValue(recordNode, fieldName));
        }
        catch (JsonDeserializationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, e, fieldName, this.getTextualBeanType(), e.getMessage());
        }
    }

    public InetAddress getAddressFromString(String address) {
        return InetAddresses.forString((String)address);
    }

    public URL getURLFromString(String address) throws MalformedURLException {
        return new URL(address);
    }

    protected abstract String getTextualBeanType();
}

