/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.json.AbstractDeserializer;

public abstract class AbstractRecordDeserializer<T extends Record>
extends AbstractDeserializer<T> {
    private static final long serialVersionUID = 1189405106065540372L;
    private static final String NAME_FIELD_NAME = "name";
    private static final String TTL_FIELD_NAME = "ttl";
    private static final String CLASS_FIELD_NAME = "class";
    private static final String RDATA_FIELD_NAME = "rdata";

    protected AbstractRecordDeserializer(Class<?> recordClass) {
        super(recordClass);
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jsonParser.getCodec();
        ObjectNode recordNode = (ObjectNode)mapper.reader().without(DeserializationFeature.UNWRAP_ROOT_VALUE).readTree(jsonParser);
        if (recordNode.hasNonNull(RDATA_FIELD_NAME)) {
            return (T)Record.fromString(this.getRecordName(recordNode), Type.value(this.getNodeStringValue(recordNode, "type")), this.getDClass(recordNode), (long)this.getRecordTTL(recordNode), this.getNodeStringValue(recordNode, RDATA_FIELD_NAME), Name.root);
        }
        return this.createRecord(this.getRecordName(recordNode), this.getDClass(recordNode), this.getRecordTTL(recordNode), recordNode);
    }

    protected abstract T createRecord(Name var1, int var2, long var3, ObjectNode var5);

    protected abstract String getTextualRecordType();

    @Override
    protected String getTextualBeanType() {
        return this.getTextualRecordType() + " record";
    }

    protected Name getRecordName(ObjectNode recordNode) {
        return this.getNodeNameValue(recordNode, NAME_FIELD_NAME);
    }

    protected int getDClass(ObjectNode recordNode) {
        String dClass = this.getNodeStringValue(recordNode, CLASS_FIELD_NAME);
        return DClass.value(dClass);
    }

    protected int getRecordTTL(ObjectNode recordNode) {
        return this.getNodeIntegerValue(recordNode, TTL_FIELD_NAME);
    }
}

