/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class CERTRecordDeserializer
extends AbstractRecordDeserializer<CERTRecord> {
    private static final long serialVersionUID = 1976274354370729318L;

    public CERTRecordDeserializer() {
        super(CERTRecord.class);
    }

    @Override
    protected CERTRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        try {
            return new CERTRecord(name, dclass, ttl, (int)this.getNodeIntegerValue(recordNode, "certType"), (int)this.getNodeIntegerValue(recordNode, "keyTag"), (int)this.getNodeIntegerValue(recordNode, "algorithm"), this.getNodeStringValue(recordNode, "cert"));
        }
        catch (IOException e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unexpectedMappingError, (Throwable)e, this.getTextualBeanType(), e.getMessage());
        }
    }

    @Override
    protected String getTextualRecordType() {
        return "CERT";
    }
}

