/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class DNSKEYRecordDeserializer
extends AbstractRecordDeserializer<DNSKEYRecord> {
    private static final long serialVersionUID = -624474520652580649L;

    public DNSKEYRecordDeserializer() {
        super(DNSKEYRecord.class);
    }

    @Override
    protected DNSKEYRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        try {
            return new DNSKEYRecord(name, dclass, ttl, (int)this.getNodeIntegerValue(recordNode, "flags"), (int)this.getNodeIntegerValue(recordNode, "protocol"), (int)this.getNodeIntegerValue(recordNode, "algorithm"), this.getNodeStringValue(recordNode, "key"));
        }
        catch (IOException e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unexpectedMappingError, (Throwable)e, this.getTextualBeanType(), e.getMessage());
        }
    }

    @Override
    protected String getTextualRecordType() {
        return "DNSKEY";
    }
}

