/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.xbill.DNS.DSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class DSRecordDeserializer
extends AbstractRecordDeserializer<DSRecord> {
    private static final long serialVersionUID = 9205297205421105521L;

    public DSRecordDeserializer() {
        super(DSRecord.class);
    }

    @Override
    protected DSRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        try {
            return new DSRecord(name, dclass, ttl, (int)this.getNodeIntegerValue(recordNode, "footprint"), (int)this.getNodeIntegerValue(recordNode, "algorithm"), (int)this.getNodeIntegerValue(recordNode, "digestId"), this.getNodeStringValue(recordNode, "digest"));
        }
        catch (IOException e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unexpectedMappingError, (Throwable)e, this.getTextualBeanType(), e.getMessage());
        }
    }

    @Override
    protected String getTextualRecordType() {
        return "DS";
    }
}

