/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.xbill.DNS.LOCRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class LOCRecordDeserializer
extends AbstractRecordDeserializer<LOCRecord> {
    private static final long serialVersionUID = -6394722407564343923L;

    public LOCRecordDeserializer() {
        super(LOCRecord.class);
    }

    @Override
    protected LOCRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        try {
            return new LOCRecord(name, dclass, ttl, this.getNodeStringValue(recordNode, "latitude"), this.getNodeStringValue(recordNode, "longitude"), this.getNodeStringValue(recordNode, "altitude"), this.getNodeStringValue(recordNode, "size"), this.getNodeStringValue(recordNode, "hPrecision"), this.getNodeStringValue(recordNode, "vPrecision"));
        }
        catch (IOException e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unexpectedMappingError, (Throwable)e, this.getTextualBeanType(), e.getMessage());
        }
    }

    @Override
    protected String getTextualRecordType() {
        return "LOC";
    }
}

