/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.xbill.DNS.MAILFWRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.utils.json.exception.MissingFieldJsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class MAILFWRecordDeserializer
extends AbstractRecordDeserializer<MAILFWRecord> {
    private static final long serialVersionUID = 3831802671840433355L;

    protected MAILFWRecordDeserializer() {
        super(MAILFWRecord.class);
    }

    @Override
    protected MAILFWRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        String originalRecipient;
        try {
            originalRecipient = this.getNodeStringValue(recordNode, "originalRecipient");
        }
        catch (MissingFieldJsonDeserializationException e) {
            return new MAILFWRecord(name, dclass, ttl, this.getNodeStringValue(recordNode, "destination"));
        }
        return new MAILFWRecord(name, dclass, ttl, originalRecipient, this.getNodeStringValue(recordNode, "destination"));
    }

    @Override
    protected String getTextualRecordType() {
        return "MAILFW";
    }
}

