/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.xbill.DNS.NSECRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class NSECRecordDeserializer
extends AbstractRecordDeserializer<NSECRecord> {
    public NSECRecordDeserializer() {
        super(NSECRecord.class);
    }

    @Override
    protected NSECRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        int[] types;
        String typesString = this.getNodeStringValue(recordNode, "types");
        if (typesString == null || typesString.trim().length() == 0) {
            types = new int[]{};
        } else {
            String[] typeStrings = typesString.trim().split(" ");
            types = new int[typeStrings.length];
            for (int i = 0; i < typeStrings.length; ++i) {
                int typeIntValue = Type.value(typeStrings[i]);
                if (typeIntValue < 0) {
                    throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.invalidFieldValue, "types", this.getTextualBeanType());
                }
                types[i] = typeIntValue;
            }
        }
        return new NSECRecord(name, dclass, ttl, this.getNodeNameValue(recordNode, "nextDomain"), types);
    }

    @Override
    protected String getTextualRecordType() {
        return "NSEC";
    }
}

