/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.utils.base64;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordSerializer;

public class RRSIGRecordSerializer
extends AbstractRecordSerializer<RRSIGRecord> {
    public RRSIGRecordSerializer() {
        super(RRSIGRecord.class);
    }

    @Override
    protected void serializeRDataFields(RRSIGRecord rrsigRecord, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        jsonGenerator.writeNumberField("typeCovered", rrsigRecord.getTypeCovered());
        jsonGenerator.writeNumberField("algorithm", rrsigRecord.getAlgorithm());
        jsonGenerator.writeNumberField("labels", rrsigRecord.getLabels());
        jsonGenerator.writeNumberField("originalTTL", rrsigRecord.getOrigTTL());
        jsonGenerator.writeNumberField("expireTime", rrsigRecord.getExpire().getTime() / 1000L);
        jsonGenerator.writeNumberField("inceptionTime", rrsigRecord.getTimeSigned().getTime() / 1000L);
        jsonGenerator.writeNumberField("keyTag", rrsigRecord.getFootprint());
        jsonGenerator.writeStringField("signerName", rrsigRecord.getSigner().toString());
        jsonGenerator.writeStringField("signature", base64.toString(rrsigRecord.getSignature()));
    }
}

