/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

public class ResourceRecordSerializationStrategy {
    private static SerializationStrategy globalSerializationStrategy = SerializationStrategy.ALWAYS_FULLY_EXPANDED_RDATA;
    private static ThreadLocal<Boolean> currentThreadLocalSerializationStrategy = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    static void setGlobalSerializationStrategy(SerializationStrategy globalSerializationStrategy) {
        ResourceRecordSerializationStrategy.globalSerializationStrategy = globalSerializationStrategy;
    }

    public static void setRawRDataFormat(Boolean rawRDataFormat) {
        if (globalSerializationStrategy == SerializationStrategy.PER_REQUEST) {
            currentThreadLocalSerializationStrategy.set(rawRDataFormat);
        }
    }

    public static Boolean isRawRDataFormat() {
        switch (globalSerializationStrategy) {
            case ALWAYS_FULLY_EXPANDED_RDATA: {
                return false;
            }
            case ALWAYS_RAW_RDATA: {
                return true;
            }
            case PER_REQUEST: {
                return currentThreadLocalSerializationStrategy.get();
            }
        }
        return false;
    }

    public static enum SerializationStrategy {
        ALWAYS_FULLY_EXPANDED_RDATA,
        ALWAYS_RAW_RDATA,
        PER_REQUEST;

    }
}

