/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordSerializer;

public class SOARecordSerializer
extends AbstractRecordSerializer<SOARecord> {
    public SOARecordSerializer() {
        super(SOARecord.class);
    }

    @Override
    protected void serializeRDataFields(SOARecord soaRecord, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        if (soaRecord.getHost() != null) {
            jsonGenerator.writeStringField("host", soaRecord.getHost().toString());
        }
        if (soaRecord.getAdmin() != null) {
            jsonGenerator.writeStringField("admin", soaRecord.getAdmin().toString());
        }
        jsonGenerator.writeStringField("serial", this.formatNumber(soaRecord.getSerial()));
        jsonGenerator.writeStringField("refresh", this.formatNumber(soaRecord.getRefresh()));
        jsonGenerator.writeStringField("retry", this.formatNumber(soaRecord.getRetry()));
        jsonGenerator.writeStringField("expire", this.formatNumber(soaRecord.getExpire()));
        jsonGenerator.writeStringField("minimum", this.formatNumber(soaRecord.getMinimum()));
    }
}

