/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils.json.resourcerecords;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.xbill.DNS.Name;
import org.xbill.DNS.SSHFPRecord;
import org.xbill.DNS.utils.json.exception.JsonDeserializationException;
import org.xbill.DNS.utils.json.resourcerecords.AbstractRecordDeserializer;

public class SSHFPRecordDeserializer
extends AbstractRecordDeserializer<SSHFPRecord> {
    private static final long serialVersionUID = -3992024906736725094L;

    public SSHFPRecordDeserializer() {
        super(SSHFPRecord.class);
    }

    @Override
    protected SSHFPRecord createRecord(Name name, int dclass, long ttl, ObjectNode recordNode) {
        try {
            return new SSHFPRecord(name, dclass, ttl, (int)this.getNodeIntegerValue(recordNode, "algorithm"), (int)this.getNodeIntegerValue(recordNode, "digestType"), this.getNodeStringValue(recordNode, "fingerprint"));
        }
        catch (IOException e) {
            throw new JsonDeserializationException(JsonDeserializationException.JsonDeserializationExceptionCode.unexpectedMappingError, (Throwable)e, this.getTextualBeanType(), e.getMessage());
        }
    }

    @Override
    protected String getTextualRecordType() {
        return "SSHFP";
    }
}

